/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.contribution.content.form.record;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.silverpeas.core.contribution.content.form.FormException;
import org.silverpeas.core.contribution.content.form.FormRuntimeException;
import org.silverpeas.core.contribution.content.form.record.GenericRecordSetManager;
import org.silverpeas.core.contribution.content.form.record.RecordRow;
import org.silverpeas.core.contribution.template.publication.PublicationTemplate;
import org.silverpeas.core.contribution.template.publication.PublicationTemplateException;
import org.silverpeas.core.contribution.template.publication.PublicationTemplateManager;
import org.silverpeas.core.persistence.jdbc.DBUtil;
import org.silverpeas.core.security.encryption.EncryptionContentIterator;
import org.silverpeas.core.security.encryption.cipher.CryptoException;
import org.silverpeas.kernel.logging.SilverLogger;
import org.silverpeas.kernel.util.StringUtil;

public class FormEncryptionContentIterator
implements EncryptionContentIterator {
    private String formName;
    private Iterator<Map<String, String>> contents;
    private Connection con;

    public FormEncryptionContentIterator() {
    }

    public FormEncryptionContentIterator(String formName) {
        this.formName = formName;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Map<String, String> next() {
        return this.contents.next();
    }

    @Override
    public boolean hasNext() {
        boolean hasNext = this.contents.hasNext();
        if (!hasNext) {
            this.commitConnection();
        }
        return hasNext;
    }

    @Override
    public void update(Map<String, String> updatedContent) {
        ArrayList<RecordRow> rowsToUpdate = new ArrayList<RecordRow>();
        for (Map.Entry<String, String> entry : updatedContent.entrySet()) {
            String key = entry.getKey();
            String[] recordIdAndFieldName = StringUtil.splitByWholeSeparator((String)key, (String)"$SP$");
            RecordRow rowToUpdate = new RecordRow(Integer.parseInt(recordIdAndFieldName[0]), recordIdAndFieldName[1], entry.getValue());
            rowsToUpdate.add(rowToUpdate);
        }
        try {
            FormEncryptionContentIterator.getGenericRecordSetManager().updateFieldRows(this.getConnection(), rowsToUpdate);
        }
        catch (Exception e) {
            this.rollbackConnection();
            throw new FormRuntimeException("Form update failure", e);
        }
    }

    @Override
    public void onError(Map<String, String> content, CryptoException ex) {
        SilverLogger.getLogger((Object)this).error((Throwable)ex);
        this.rollbackConnection();
        throw new FormRuntimeException("Form encryption error", ex);
    }

    @Override
    public void init() {
        ArrayList<Map<String, String>> theContents = new ArrayList<Map<String, String>>();
        if (StringUtil.isDefined((String)this.formName)) {
            Map<String, String> toProcess = this.getFormData(this.formName);
            theContents.add(toProcess);
        } else {
            List<PublicationTemplate> forms;
            try {
                forms = PublicationTemplateManager.getInstance().getEncryptedPublicationTemplates();
            }
            catch (PublicationTemplateException e) {
                throw new FormRuntimeException("Encrypted forms getting failure", (Throwable)((Object)e));
            }
            theContents.addAll(forms.stream().map(form -> this.getFormData(form.getFileName())).collect(Collectors.toList()));
        }
        this.contents = theContents.iterator();
        this.openConnection();
    }

    private Map<String, String> getFormData(String formName) {
        List<RecordRow> rows;
        try {
            rows = FormEncryptionContentIterator.getGenericRecordSetManager().getAllRecordsOfTemplate(formName);
        }
        catch (FormException e) {
            throw new FormRuntimeException("Form data getting failure", (Throwable)((Object)e));
        }
        HashMap<String, String> toProcess = new HashMap<String, String>();
        for (RecordRow row : rows) {
            toProcess.put(row.getRecordId() + "$SP$" + row.getFieldName(), row.getFieldValue());
        }
        return toProcess;
    }

    private static GenericRecordSetManager getGenericRecordSetManager() {
        return GenericRecordSetManager.getInstance();
    }

    private void openConnection() {
        try {
            this.con = DBUtil.openConnection();
            this.con.setAutoCommit(false);
        }
        catch (Exception e) {
            throw new FormRuntimeException("Database connection failure", e);
        }
    }

    private Connection getConnection() {
        return this.con;
    }

    private void rollbackConnection() {
        DBUtil.rollback((Connection)this.con);
        DBUtil.close((Connection)this.con);
    }

    private void commitConnection() {
        try {
            this.con.commit();
        }
        catch (SQLException e) {
            throw new FormRuntimeException("Transaction commit failure", e);
        }
        finally {
            DBUtil.close((Connection)this.con);
        }
    }
}

