/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.contribution.content.form.filter;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.silverpeas.core.contribution.content.form.DataRecord;
import org.silverpeas.core.contribution.content.form.Field;
import org.silverpeas.core.contribution.content.form.FieldTemplate;
import org.silverpeas.core.contribution.content.form.Form;
import org.silverpeas.core.contribution.content.form.FormException;
import org.silverpeas.core.contribution.content.form.RecordTemplate;
import org.silverpeas.core.contribution.content.form.Util;
import org.silverpeas.core.contribution.content.form.filter.EqualityFilter;
import org.silverpeas.core.contribution.content.form.filter.FieldFilter;
import org.silverpeas.core.contribution.content.form.filter.GreaterThenFilter;
import org.silverpeas.core.contribution.content.form.filter.LessThenFilter;
import org.silverpeas.core.contribution.content.form.filter.LikeFilter;
import org.silverpeas.core.contribution.content.form.filter.RecordFilter;
import org.silverpeas.core.contribution.content.form.filter.SimpleRecordFilter;
import org.silverpeas.core.contribution.content.form.form.XmlForm;
import org.silverpeas.core.contribution.content.form.record.GenericFieldTemplate;
import org.silverpeas.core.contribution.content.form.record.GenericRecordTemplate;

public class FilterManager {
    private final RecordTemplate template;
    private GenericRecordTemplate criteriaTemplate;
    private Form criteriaForm;
    private String lang;
    private Map<String, FieldTemplate> fieldsParameter = Collections.synchronizedMap(new HashMap());

    public FilterManager(RecordTemplate rowTemplate, String lang) {
        this.template = rowTemplate;
        this.lang = lang;
    }

    public Form getCriteriaForm() throws FormException {
        if (this.criteriaForm == null) {
            this.criteriaForm = new XmlForm(this.getCriteriaTemplate());
        }
        return this.criteriaForm;
    }

    public RecordTemplate getCriteriaTemplate() throws FormException {
        if (this.criteriaTemplate == null) {
            FieldTemplate[] filteredFields;
            this.criteriaTemplate = new GenericRecordTemplate();
            for (FieldTemplate filteredField : filteredFields = this.template.getFieldTemplates()) {
                GenericFieldTemplate criteriumField;
                String filteredType = filteredField.getTypeName();
                String filteredName = filteredField.getFieldName();
                String filteredLabel = filteredField.getLabel(this.lang);
                switch (filteredType) {
                    case "text": {
                        criteriumField = this.processText(filteredName, filteredLabel);
                        break;
                    }
                    case "jdbc": {
                        criteriumField = this.processJDBC(filteredType, filteredName, filteredLabel);
                        break;
                    }
                    case "date": {
                        criteriumField = this.processDate(filteredName, filteredLabel);
                        break;
                    }
                    default: {
                        criteriumField = new GenericFieldTemplate(filteredName + "__equal", filteredType);
                        criteriumField.addLabel(filteredLabel + " " + Util.getString("eq", this.lang), this.lang);
                    }
                }
                this.criteriaTemplate.addFieldTemplate(criteriumField);
            }
        }
        return this.criteriaTemplate;
    }

    private GenericFieldTemplate processDate(String filteredName, String filteredLabel) throws FormException {
        GenericFieldTemplate criteriumField = new GenericFieldTemplate(filteredName + "__lt", "date");
        criteriumField.addLabel(filteredLabel + " " + Util.getString("le", this.lang), this.lang);
        this.criteriaTemplate.addFieldTemplate(criteriumField);
        criteriumField = new GenericFieldTemplate(filteredName + "__gt", "date");
        criteriumField.addLabel(filteredLabel + " " + Util.getString("ge", this.lang), this.lang);
        return criteriumField;
    }

    private GenericFieldTemplate processJDBC(String filteredType, String filteredName, String filteredLabel) throws FormException {
        GenericFieldTemplate criteriumField = new GenericFieldTemplate(filteredName + "__equal", filteredType);
        criteriumField.addLabel(filteredLabel + " " + Util.getString("eq", this.lang), this.lang);
        if (this.fieldsParameter.containsKey(filteredName)) {
            FieldTemplate field = this.fieldsParameter.get(filteredName);
            Map<String, String> parameters = field.getParameters(this.lang);
            Set<String> keys = parameters.keySet();
            for (String key : keys) {
                criteriumField.addParameter(key, parameters.get(key));
            }
            criteriumField.addParameter("displayer", "listbox");
        }
        return criteriumField;
    }

    private GenericFieldTemplate processText(String filteredName, String filteredLabel) throws FormException {
        GenericFieldTemplate criteriumField = new GenericFieldTemplate(filteredName + "__like", "text");
        criteriumField.addLabel(filteredLabel + " " + Util.getString("eq", this.lang), this.lang);
        if (this.fieldsParameter.containsKey(filteredName)) {
            FieldTemplate field = this.fieldsParameter.get(filteredName);
            criteriumField.setDisplayerName("listbox");
            Map<String, String> parameters = field.getParameters(this.lang);
            Set<String> keys = parameters.keySet();
            for (String key : keys) {
                criteriumField.addParameter(key, parameters.get(key));
            }
        }
        return criteriumField;
    }

    public DataRecord getEmptyCriteriaRecord() throws FormException {
        return this.getCriteriaTemplate().getEmptyRecord();
    }

    public void addFieldParameter(String fieldName, FieldTemplate field) {
        this.fieldsParameter.put(fieldName, field);
    }

    public RecordFilter getRecordFilter(DataRecord criteriaRecord) throws FormException {
        String[] criteriaNames;
        SimpleRecordFilter filter = new SimpleRecordFilter();
        for (String criteriaName : criteriaNames = this.getCriteriaTemplate().getFieldNames()) {
            FieldFilter fieldFilter;
            String filterKind;
            Field criteria = criteriaRecord.getField(criteriaName);
            if (criteria.isNull()) continue;
            String filteredName = this.getFilteredName(criteriaName);
            switch (filterKind = this.getFilterKind(criteriaName)) {
                case "like": {
                    fieldFilter = new LikeFilter(criteria);
                    break;
                }
                case "lt": {
                    fieldFilter = new LessThenFilter(criteria);
                    break;
                }
                case "gt": {
                    fieldFilter = new GreaterThenFilter(criteria);
                    break;
                }
                case "equal": {
                    fieldFilter = new EqualityFilter(criteria);
                    break;
                }
                default: {
                    fieldFilter = null;
                }
            }
            if (fieldFilter == null) continue;
            filter.addFieldFilter(filteredName, fieldFilter);
        }
        return filter;
    }

    private String getFilteredName(String criteriaName) {
        int sep = criteriaName.lastIndexOf("__");
        if (sep == -1) {
            return criteriaName;
        }
        return criteriaName.substring(0, sep);
    }

    private String getFilterKind(String criteriaName) {
        int sep = criteriaName.lastIndexOf("__");
        if (sep == -1 || sep + 2 >= criteriaName.length()) {
            return "";
        }
        return criteriaName.substring(sep + 2);
    }
}

