/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.contribution.content.form.field;

import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import org.silverpeas.core.ResourceReference;
import org.silverpeas.core.admin.service.OrganizationControllerProvider;
import org.silverpeas.core.admin.space.SpaceInstLight;
import org.silverpeas.core.admin.user.model.UserDetail;
import org.silverpeas.core.contribution.content.form.AbstractField;
import org.silverpeas.core.contribution.content.form.Field;
import org.silverpeas.core.contribution.content.form.FormException;
import org.silverpeas.core.i18n.I18NHelper;
import org.silverpeas.core.node.model.NodeDetail;
import org.silverpeas.core.node.model.NodePK;
import org.silverpeas.core.node.model.NodePath;
import org.silverpeas.core.node.service.NodeService;
import org.silverpeas.kernel.util.StringUtil;

public class ExplorerField
extends AbstractField {
    private static final long serialVersionUID = -4982574221213514901L;
    public static final String TYPE = "explorer";
    private String pk = null;

    @Override
    public String getTypeName() {
        return TYPE;
    }

    public String getNodePK() {
        return this.pk;
    }

    public void setNodePK(String pk) {
        this.pk = pk;
    }

    public boolean isReadOnly() {
        return false;
    }

    @Override
    public String getValue() {
        return this.getValue(I18NHelper.DEFAULT_LANGUAGE);
    }

    @Override
    public String getValue(String language) {
        ResourceReference ref = (ResourceReference)this.getObjectValue();
        if (ref == null) {
            return "";
        }
        return this.getPath(ref.getInstanceId(), ref.getId(), language);
    }

    @Override
    public void setValue(String value) throws FormException {
    }

    @Override
    public void setValue(String value, String language) throws FormException {
    }

    @Override
    public boolean acceptValue(String value) {
        return false;
    }

    @Override
    public boolean acceptValue(String value, String language) {
        return false;
    }

    @Override
    public Object getObjectValue() {
        if (!StringUtil.isDefined((String)this.getNodePK())) {
            return null;
        }
        String[] ids = this.getNodePK().split("-");
        return new ResourceReference(ids[1], ids[0]);
    }

    @Override
    public void setObjectValue(Object value) throws FormException {
        if (value instanceof ResourceReference) {
            ResourceReference ref = (ResourceReference)value;
            this.setNodePK(ref.getInstanceId() + "-" + ref.getId());
        } else if (value == null) {
            this.setNodePK(null);
        } else {
            throw new FormException("The value " + String.valueOf(value) + " isn't a node!", new String[0]);
        }
    }

    @Override
    public boolean acceptObjectValue(Object value) {
        return value instanceof UserDetail && !this.isReadOnly();
    }

    @Override
    public String getStringValue() {
        return this.getNodePK();
    }

    @Override
    public void setStringValue(String value) {
        this.setNodePK(value);
    }

    @Override
    public boolean acceptStringValue(String value) {
        return !this.isReadOnly();
    }

    @Override
    public boolean isNull() {
        return this.getNodePK() == null;
    }

    @Override
    public void setNull() throws FormException {
        this.setNodePK(null);
    }

    public boolean equals(Object o) {
        String s = this.getNodePK();
        if (o instanceof ExplorerField) {
            String t = ((ExplorerField)o).getNodePK();
            return s == null || s.equals(t);
        }
        return false;
    }

    @Override
    public int compareTo(@Nonnull Field o) {
        String s = this.getValue();
        if (s == null) {
            s = "";
        }
        if (o instanceof ExplorerField) {
            String t = o.getValue();
            if (t == null) {
                t = "";
            }
            if (s.equals(t)) {
                s = this.getNodePK();
                if (s == null) {
                    s = "";
                }
                if ((t = ((ExplorerField)o).getNodePK()) == null) {
                    t = "";
                }
            }
            return s.compareTo(t);
        }
        return -1;
    }

    public int hashCode() {
        String s = this.getNodePK();
        return s.hashCode();
    }

    private String getPath(String componentId, String nodeId, String language) {
        StringBuilder path = new StringBuilder();
        if (componentId != null && !"useless".equals(componentId)) {
            ExplorerField.setSpacePath(componentId, language, path);
            path.append(OrganizationControllerProvider.getOrganisationController().getComponentInstLight(componentId).getLabel(language));
            ExplorerField.setNodePath(componentId, nodeId, language, path);
        }
        return path.toString();
    }

    private static void setNodePath(String componentId, String nodeId, String language, StringBuilder path) {
        NodePK nodePk;
        StringBuilder pathString = new StringBuilder();
        if (nodeId == null) {
            return;
        }
        NodeService nodeService = NodeService.get();
        NodePath listPath = nodeService.getPath(nodePk = new NodePK(nodeId, componentId));
        if (listPath != null) {
            Collections.reverse(listPath);
            for (NodeDetail nodeInPath : listPath) {
                if (nodeInPath.getNodePK().getId().equals("0")) continue;
                String nodeName = language != null ? nodeInPath.getName(language) : nodeInPath.getName();
                pathString.append(nodeName).append(" > ");
            }
            if (pathString.length() > 0) {
                pathString.delete(pathString.length() - 3, pathString.length());
            }
        }
        if (pathString.length() > 0) {
            path.append(" > ").append((CharSequence)pathString);
        }
    }

    private static void setSpacePath(String componentId, String language, StringBuilder path) {
        List<SpaceInstLight> listSpaces = OrganizationControllerProvider.getOrganisationController().getPathToComponent(componentId);
        for (SpaceInstLight space : listSpaces) {
            path.append(space.getName(language)).append(" > ");
        }
    }
}

