/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.contribution.content.form.field;

import java.util.List;
import org.silverpeas.core.admin.service.OrganizationControllerProvider;
import org.silverpeas.core.admin.space.SpaceInstLight;
import org.silverpeas.core.contribution.content.form.field.TextField;
import org.silverpeas.core.node.model.NodeDetail;
import org.silverpeas.core.node.model.NodePK;
import org.silverpeas.core.node.model.NodePath;
import org.silverpeas.core.node.service.NodeService;
import org.silverpeas.core.util.WebEncodeHelper;

public class AccessPathField
extends TextField {
    private static final long serialVersionUID = 9112703938534783673L;
    public static final String TYPE = "accessPath";
    private String value = "";

    @Override
    public String getTypeName() {
        return TYPE;
    }

    @Override
    public String getStringValue() {
        return this.value;
    }

    @Override
    public void setStringValue(String value) {
        this.value = value;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    public String getAccessPath(String componentId, String nodeId, String contentLanguage) {
        StringBuilder currentAccessPath = new StringBuilder();
        if (componentId != null && !"useless".equals(componentId)) {
            AccessPathField.setSpacePath(componentId, currentAccessPath);
            currentAccessPath.append(OrganizationControllerProvider.getOrganisationController().getComponentInstLight(componentId).getLabel());
            AccessPathField.setNodePath(componentId, nodeId, contentLanguage, currentAccessPath);
        }
        return currentAccessPath.toString();
    }

    private static void setNodePath(String componentId, String nodeId, String contentLanguage, StringBuilder currentAccessPath) {
        NodePK nodePk;
        StringBuilder pathString = new StringBuilder();
        if (nodeId == null) {
            return;
        }
        NodeService nodeService = NodeService.get();
        NodePath listPath = nodeService.getPath(nodePk = new NodePK(nodeId, componentId));
        if (listPath != null) {
            for (NodeDetail nodeInPath : listPath) {
                if (nodeInPath.getNodePK().getId().equals("0")) continue;
                String nodeName = contentLanguage != null ? nodeInPath.getName(contentLanguage) : nodeInPath.getName();
                pathString.append(WebEncodeHelper.javaStringToHtmlString((String)nodeName)).append(" > ");
            }
            if (pathString.length() > 0) {
                pathString.delete(pathString.length() - 3, pathString.length());
            }
        }
        if (pathString.length() > 0) {
            currentAccessPath.append(" > ").append((CharSequence)pathString);
        }
    }

    private static void setSpacePath(String componentId, StringBuilder currentAccessPath) {
        List<SpaceInstLight> listSpaces = OrganizationControllerProvider.getOrganisationController().getPathToComponent(componentId);
        for (SpaceInstLight space : listSpaces) {
            currentAccessPath.append(space.getName()).append(" > ");
        }
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}

