/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.contribution.content.form.displayers;

import java.io.PrintWriter;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.ecs.xhtml.div;
import org.silverpeas.core.contribution.content.form.FieldTemplate;
import org.silverpeas.core.contribution.content.form.FormException;
import org.silverpeas.core.contribution.content.form.PagesContext;
import org.silverpeas.core.contribution.content.form.Util;
import org.silverpeas.core.contribution.content.form.displayers.AbstractFieldDisplayer;
import org.silverpeas.core.contribution.content.form.field.UserField;
import org.silverpeas.core.html.plugin.UserGroupSelectProducer;
import org.silverpeas.kernel.util.StringUtil;

public class UserFieldDisplayer
extends AbstractFieldDisplayer<UserField> {
    private static final int NB_HTML_ELEMENTS = 2;

    public String[] getManagedTypes() {
        return new String[]{"user"};
    }

    @Override
    public void displayScripts(PrintWriter out, FieldTemplate template, PagesContext pagesContext) {
        UserFieldDisplayer.produceMandatoryCheck(out, template, pagesContext);
        Util.getJavascriptChecker(template.getFieldName(), pagesContext, out);
    }

    @Override
    public void display(PrintWriter out, UserField field, FieldTemplate template, PagesContext pageContext) throws FormException {
        boolean writable = !template.isHidden() && !template.isDisabled() && !template.isReadOnly();
        String language = pageContext.getLanguage();
        String selectUserLab = Util.getString("userPanel", language);
        String deleteUserLab = Util.getString("clearUser", language);
        String fieldName = template.getFieldName();
        String rootContainerId = "select-user-group-" + fieldName + String.valueOf(UUID.randomUUID());
        String userId = field.getTypeName().equals("user") ? field.getUserId() : "";
        UserGroupSelectProducer selectUser = UserGroupSelectProducer.withContainerId(rootContainerId).withUserInputName(fieldName).selectionOf(UserGroupSelectProducer.SelectionType.USER).multiple(false).readOnly(!writable).hidden(template.isHidden()).withUserIds(userId).withUserPanelButtonLabel(selectUserLab).withRemoveButtonLabel(deleteUserLab);
        if (writable) {
            boolean usersOfInstanceOnly;
            Map<String, String> parameters = template.getParameters(pageContext.getLanguage());
            String roles = parameters.get("roles");
            boolean bl = usersOfInstanceOnly = StringUtil.getBooleanValue((String)parameters.get("usersOfInstanceOnly")) || StringUtil.isDefined((String)roles);
            if (usersOfInstanceOnly) {
                selectUser.filterOnComponentId(pageContext.getComponentId());
            }
            selectUser.filterOnRoles(roles);
            selectUser.mandatory(template.isMandatory() && pageContext.useMandatory());
        }
        out.println(new div().setID(rootContainerId));
        out.println(selectUser.produce());
    }

    @Override
    public List<String> update(String newId, UserField field, FieldTemplate template, PagesContext pageContext) throws FormException {
        if ("user".equals(field.getTypeName())) {
            if (!StringUtil.isDefined((String)newId)) {
                field.setNull();
            } else {
                field.setUserId(newId);
            }
        } else {
            throw new FormException("Incorrect field value type. Expected {0}", "user");
        }
        return Collections.emptyList();
    }

    @Override
    public boolean isDisplayedMandatory() {
        return true;
    }

    @Override
    public int getNbHtmlObjectsDisplayed(FieldTemplate template, PagesContext pageContext) {
        return 2;
    }
}

