/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.contribution.content.form.displayers;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.silverpeas.core.contribution.content.form.FieldTemplate;
import org.silverpeas.core.contribution.content.form.FormException;
import org.silverpeas.core.contribution.content.form.PagesContext;
import org.silverpeas.core.contribution.content.form.Util;
import org.silverpeas.core.contribution.content.form.displayers.AbstractFieldDisplayer;
import org.silverpeas.core.contribution.content.form.field.TextField;
import org.silverpeas.kernel.logging.SilverLogger;
import org.silverpeas.kernel.util.StringUtil;

public class RadioButtonDisplayer
extends AbstractFieldDisplayer<TextField> {
    public String[] getManagedTypes() {
        String[] s = new String[]{};
        s[0] = "text";
        return s;
    }

    @Override
    public void displayScripts(PrintWriter out, FieldTemplate template, PagesContext pagesContext) {
        String language = pagesContext.getLanguage();
        String fieldName = template.getFieldName();
        if (template.isMandatory() && pagesContext.useMandatory()) {
            out.println(" var checked = $('input[type=radio][name=" + fieldName + "]:checked').length == 1;\n");
            out.println(" if(!ignoreMandatory && checked == false) {");
            out.println("   errorMsg+=\"  - '" + template.getLabel(language) + "' " + Util.getString("GML.MustBeFilled", language) + "\\n\";\n");
            out.println("   errorNb++;");
            out.println(" }");
        }
        Util.getJavascriptChecker(template.getFieldName(), pagesContext, out);
    }

    @Override
    public void display(PrintWriter out, TextField field, FieldTemplate template, PagesContext pageContext) throws FormException {
        String value;
        String keys = "";
        String values = "";
        Object html2 = "";
        int cols = 1;
        String language = pageContext.getLanguage();
        Object cssClass = null;
        String fieldName = template.getFieldName();
        Map<String, String> parameters = template.getParameters(language);
        if (parameters.containsKey("keys")) {
            keys = parameters.get("keys");
        }
        if (parameters.containsKey("values")) {
            values = parameters.get("values");
        }
        if (parameters.containsKey("class") && StringUtil.isDefined((String)(cssClass = parameters.get("class")))) {
            cssClass = "class=\"" + (String)cssClass + "\"";
        }
        try {
            if (parameters.containsKey("cols")) {
                cols = Integer.valueOf(parameters.get("cols"));
            }
        }
        catch (NumberFormatException nfe) {
            SilverLogger.getLogger((Object)this).error("Illegal parameter column: " + parameters.get("cols"), (Throwable)nfe);
            cols = 1;
        }
        String defaultValue = this.getDefaultValue(template, pageContext);
        String string = value = !field.isNull() ? field.getValue(pageContext.getLanguage()) : defaultValue;
        if (pageContext.isBlankFieldsUse()) {
            value = "";
        }
        if (keys.equals("") && !values.equals("")) {
            keys = values;
        }
        if (values.equals("") && !keys.equals("")) {
            values = keys;
        }
        StringTokenizer stKeys = new StringTokenizer(keys, "##");
        StringTokenizer stValues = new StringTokenizer(values, "##");
        int nbTokens = this.getNbHtmlObjectsDisplayed(template, pageContext);
        if (stKeys.countTokens() == stValues.countTokens()) {
            html2 = (String)html2 + "<table border=\"0\">";
            int col = 0;
            for (int i = 0; i < nbTokens; ++i) {
                if (col == 0) {
                    html2 = (String)html2 + "<tr>";
                }
                ++col;
                html2 = (String)html2 + "<td>";
                String optKey = stKeys.nextToken();
                String optValue = stValues.nextToken();
                if (StringUtil.isDefined((String)cssClass)) {
                    html2 = (String)html2 + "<span " + (String)cssClass + ">";
                }
                html2 = (String)html2 + "<input type=\"radio\" id=\"" + fieldName + "_" + i + "\" name=\"" + fieldName + "\" value=\"" + optKey + "\" ";
                if (template.isDisabled() || template.isReadOnly()) {
                    html2 = (String)html2 + " disabled=\"disabled\" ";
                }
                if (optKey.equals(value)) {
                    html2 = (String)html2 + " checked=\"checked\" ";
                }
                html2 = (String)html2 + "/>&nbsp;" + optValue;
                if (StringUtil.isDefined((String)cssClass)) {
                    html2 = (String)html2 + "</span>";
                }
                if (i == nbTokens - 1 && template.isMandatory() && !template.isDisabled() && !template.isReadOnly() && !template.isHidden() && pageContext.useMandatory()) {
                    html2 = (String)html2 + Util.getMandatorySnippet();
                }
                html2 = (String)html2 + "</td>";
                if (col != cols) continue;
                html2 = (String)html2 + "</tr>";
                col = 0;
            }
            if (col != 0) {
                html2 = (String)html2 + "</tr>";
            }
            html2 = (String)html2 + "</table>";
        }
        out.println((String)html2);
    }

    @Override
    public List<String> update(String newValue, TextField field, FieldTemplate template, PagesContext PagesContext2) throws FormException {
        if (!"text".equals(field.getTypeName())) {
            throw new FormException("Incorrect field type '{0}', expected; {0}", "text");
        }
        if (!field.acceptValue(newValue, PagesContext2.getLanguage())) {
            throw new FormException("Incorrect field value type. Expected {0}", "text");
        }
        field.setValue(newValue, PagesContext2.getLanguage());
        return new ArrayList<String>();
    }

    @Override
    public boolean isDisplayedMandatory() {
        return true;
    }

    @Override
    public int getNbHtmlObjectsDisplayed(FieldTemplate template, PagesContext pagesContext) {
        String keys = "";
        String values = "";
        Map<String, String> parameters = template.getParameters(pagesContext.getLanguage());
        if (parameters.containsKey("keys")) {
            keys = parameters.get("keys");
        }
        if (parameters.containsKey("values")) {
            values = parameters.get("values");
        }
        if (keys.equals("") && !values.equals("")) {
            keys = values;
        }
        StringTokenizer stKeys = new StringTokenizer(keys, "##");
        return stKeys.countTokens();
    }
}

