/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.contribution.content.form;

import java.io.PrintWriter;
import java.util.Map;
import org.apache.ecs.xhtml.script;
import org.silverpeas.core.contribution.content.form.FieldTemplate;
import org.silverpeas.core.contribution.content.form.PagesContext;
import org.silverpeas.core.util.URLUtil;
import org.silverpeas.core.util.WebEncodeHelper;
import org.silverpeas.core.util.file.FileServerUtils;
import org.silverpeas.kernel.bundle.LocalizationBundle;
import org.silverpeas.kernel.bundle.ResourceLocator;
import org.silverpeas.kernel.bundle.SettingBundle;
import org.silverpeas.kernel.util.StringUtil;

public class Util {
    private static final SettingBundle formIcons = ResourceLocator.getSettingBundle((String)"org.silverpeas.form.settings.formIcons");
    private static final SettingBundle settings = ResourceLocator.getSettingBundle((String)"org.silverpeas.form.settings.form");
    private static final String path = URLUtil.getApplicationURL();
    private static LocalizationBundle message;
    private static String language;

    public static String getPath() {
        return path;
    }

    public static String getSetting(String setting) {
        return settings.getString(setting);
    }

    public static String getIcon(String icon) {
        return path + formIcons.getString(icon);
    }

    public static String getString(String msg, String language) {
        Util.setLanguage(language);
        return message.getString(msg);
    }

    public static String getJavascriptIncludes(String language) {
        StringBuilder includes = new StringBuilder();
        includes.append(new script().setType("text/javascript").addElement("window.CKEDITOR_BASEPATH = '" + URLUtil.getApplicationURL() + "/wysiwyg/jsp/ckeditor/';").toString());
        Util.addSilverpeasScript(includes, "/wysiwyg/jsp/ckeditor/ckeditor.js");
        Util.addSilverpeasScript(includes, "/util/javaScript/dateUtils.js");
        Util.addSilverpeasScript(includes, "/util/javaScript/checkForm.js");
        String webContext = path;
        Util.addExternalStyleSheet(includes, webContext, "/util/yui/fonts/fonts-min.css");
        Util.addExternalStyleSheet(includes, webContext, "/util/yui/autocomplete/assets/skins/sam/autocomplete.css");
        Util.addExternalScript(includes, webContext, "/util/yui/yahoo-dom-event/yahoo-dom-event.js");
        Util.addExternalScript(includes, webContext, "/util/yui/animation/animation-min.js");
        Util.addExternalScript(includes, webContext, "/util/yui/datasource/datasource-min.js");
        Util.addExternalScript(includes, webContext, "/util/yui/autocomplete/autocomplete-min.js");
        Util.addExternalScript(includes, webContext, "/util/javaScript/jquery/jquery.ui.datepicker-" + language + ".js");
        Util.addExternalScript(includes, webContext, "/util/javaScript/silverpeas-defaultDatePicker.js");
        return includes.toString();
    }

    private static void addSilverpeasScript(StringBuilder includes, String script2) {
        String normalizedUrl = URLUtil.getMinifiedWebResourceUrl(path + script2);
        includes.append("<script type=\"text/javascript\" src=\"").append(URLUtil.addFingerprintVersionOn(normalizedUrl)).append("\"></script>\n");
    }

    private static void addExternalStyleSheet(StringBuilder includes, String webContext, String styleSheet) {
        String normalizedUrl = URLUtil.getMinifiedWebResourceUrl(webContext + styleSheet);
        includes.append("<link rel=\"stylesheet\" type=\"text/css\" href=\"").append(URLUtil.addFingerprintVersionOn(normalizedUrl)).append("\" />\n");
    }

    private static void addExternalScript(StringBuilder includes, String webContext, String script2) {
        String normalizedUrl = URLUtil.getMinifiedWebResourceUrl(webContext + script2);
        includes.append("<script type=\"text/javascript\" src=\"").append(URLUtil.addFingerprintVersionOn(normalizedUrl)).append("\"></script>\n");
    }

    public static void getJavascriptChecker(String fieldName, PagesContext pageContext, PrintWriter out) {
        String jsFunction = "check" + FileServerUtils.replaceAccentChars(fieldName.replace(' ', '_'));
        out.println(" try { ");
        out.println("if (typeof(" + jsFunction + ") == 'function')");
        out.println(" \t" + jsFunction + "('" + pageContext.getLanguage() + "');");
        out.println(" } catch (e) { ");
        out.println(" \t//catch all exceptions");
        out.println(" } ");
    }

    public static void includeFileNameLengthChecker(FieldTemplate template, PagesContext pageContext, PrintWriter out) {
        out.println(" //check length of filename ");
        out.println("   var lastIndexOfPathSeparator = field.value.lastIndexOf('/');");
        out.println("   if (lastIndexOfPathSeparator == -1) {");
        out.println("   //check Windows path");
        out.println("     lastIndexOfPathSeparator = field.value.lastIndexOf('\\\\');");
        out.println("   } ");
        out.println("   if (lastIndexOfPathSeparator == -1) { ");
        out.println("     lastIndexOfPathSeparator = 0;");
        out.println("   } ");
        out.println("   var filename = field.value.substring(lastIndexOfPathSeparator); ");
        out.println("   if (filename.length > 100) { ");
        out.println("       errorMsg+=\"  - '" + WebEncodeHelper.javaStringToJsString((String)template.getLabel(pageContext.getLanguage())) + "' " + Util.getString("form.field.file.toolong", language) + "\\n \";");
        out.println("       errorNb++;");
        out.println("   } ");
    }

    private static synchronized void setLanguage(String lg) {
        if (language == null || !language.trim().toLowerCase().equals(lg.trim().toLowerCase())) {
            language = lg;
            message = ResourceLocator.getLocalizationBundle((String)"org.silverpeas.form.multilang.formBundle", (String)language);
        }
    }

    public static String getMandatorySnippet() {
        return "&nbsp;<img src=\"" + Util.getIcon("mandatoryField") + "\" width=\"5\" height=\"5\" alt=\"" + Util.getString("GML.requiredField", language) + "\"/>";
    }

    public static boolean getBooleanValue(Map<String, String> parameters, String parameter) {
        String paramValue = parameters.containsKey(parameter) ? parameters.get(parameter) : "false";
        return Boolean.parseBoolean(paramValue);
    }

    public static void printOneMoreInputSnippet(String fieldName, PagesContext pageContext, PrintWriter out) {
        out.println("<a href=\"#\" class=\"moreField\" id=\"moreField-" + fieldName + "\" onclick=\"showOneMoreField('" + fieldName + "');return false;\">");
        out.println("<img src=\"" + Util.getIcon("add") + "\" width=\"14px\"> ");
        out.println(Util.getString("field.multivaluable.add", pageContext.getLanguage()));
        out.println("</a>");
    }

    public static String getFieldOccurrenceName(String fieldName, int occurrence) {
        if (occurrence == 0) {
            return fieldName;
        }
        return fieldName + "__SSPP__" + occurrence;
    }

    public static boolean isEmptyFieldsDisplayed() {
        return StringUtil.getBooleanValue((String)Util.getSetting("form.view.emptyFields.displayed"));
    }

    public static boolean isOperatorsChoiceEnabled() {
        return StringUtil.getBooleanValue((String)Util.getSetting("form.field.checkbox.operators.choice"));
    }

    public static String getDefaultOperator() {
        return Util.getSetting("form.field.checkbox.operator.default");
    }
}

