/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.contribution.content.form;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.silverpeas.core.contribution.content.form.Field;
import org.silverpeas.core.contribution.content.form.FieldDisplayer;
import org.silverpeas.core.contribution.content.form.FormException;
import org.silverpeas.core.contribution.content.form.FormFatalException;
import org.silverpeas.kernel.bundle.ResourceLocator;
import org.silverpeas.kernel.bundle.SettingBundle;
import org.silverpeas.kernel.logging.SilverLogger;

public class TypeManager {
    private static final TypeManager instance = new TypeManager();
    private final Map<String, Class<? extends Field>> implementations = new HashMap<String, Class<? extends Field>>();
    private final Map<String, List<String>> typeName2displayerNames = new HashMap<String, List<String>>();
    private final Map<String, Class<FieldDisplayer<? extends Field>>> displayerId2displayerClass = new HashMap<String, Class<FieldDisplayer<? extends Field>>>();

    private TypeManager() {
        try {
            this.init();
        }
        catch (FormException e) {
            SilverLogger.getLogger((Object)this).error(e.getMessage(), (Throwable)((Object)e));
        }
    }

    public static TypeManager getInstance() {
        return instance;
    }

    public String[] getTypeNames() {
        Set<String> keys = this.implementations.keySet();
        return keys.toArray(new String[0]);
    }

    public Class<? extends Field> getFieldImplementation(String typeName) throws FormException {
        if (!this.implementations.containsKey(typeName)) {
            throw new FormException("No such field of type {0}", typeName);
        }
        return this.implementations.get(typeName);
    }

    public String getDisplayerName(String typeName) throws FormException {
        List<String> displayerNames = this.typeName2displayerNames.get(typeName);
        if (displayerNames == null || displayerNames.isEmpty()) {
            throw new FormException("No such displayer for fields of type {0}", typeName);
        }
        return displayerNames.get(0);
    }

    public <T extends Field> FieldDisplayer<T> getDisplayer(String typeName, String displayerName) throws FormException {
        String displayerId = this.getDisplayerId(typeName, displayerName);
        Class<FieldDisplayer<? extends Field>> displayerClass = this.displayerId2displayerClass.get(displayerId);
        if (displayerClass == null) {
            List<String> displayerNames = this.typeName2displayerNames.get(typeName);
            if (displayerNames == null || displayerNames.isEmpty()) {
                throw new FormException("No displayer found for field of type {0}", typeName);
            }
            throw new FormException("No field displayer named {0} is found", displayerName);
        }
        return this.constructDisplayer(displayerClass);
    }

    public void setFieldImplementation(String fieldClassName, String typeName) throws FormException {
        Class<? extends Field> fieldImplementation = this.getFieldClass(fieldClassName);
        this.implementations.put(typeName, fieldImplementation);
    }

    public void setDisplayer(String displayerClassName, String typeName, String displayerName, boolean defaultDisplayer) throws FormException {
        Class<FieldDisplayer<? extends Field>> displayerClass = this.getDisplayerClass(displayerClassName);
        String displayerId = this.getDisplayerId(typeName, displayerName);
        List<String> displayerNames = this.typeName2displayerNames.get(typeName);
        if (displayerNames == null) {
            displayerNames = new ArrayList<String>();
            displayerNames.add(displayerName);
            this.typeName2displayerNames.put(typeName, displayerNames);
        } else if (defaultDisplayer) {
            displayerNames.add(0, displayerName);
        } else {
            displayerNames.add(displayerName);
        }
        this.displayerId2displayerClass.put(displayerId, displayerClass);
    }

    public Map<String, List<String>> getTypesAndDisplayers() {
        return this.typeName2displayerNames;
    }

    private String getDisplayerId(String typeName, String displayerName) {
        return typeName + "." + displayerName;
    }

    private String extractTypeName(String identifier) {
        int dot = identifier.indexOf(46);
        if (dot <= 0) {
            return identifier.trim();
        }
        return identifier.substring(0, dot).trim();
    }

    private String extractClassKind(String identifier) {
        int dot = identifier.indexOf(46);
        if (dot == -1 || dot + 1 == identifier.length()) {
            return "";
        }
        String afterFirstDot = identifier.substring(dot + 1);
        if ((dot = afterFirstDot.indexOf(46)) == -1) {
            return afterFirstDot.trim();
        }
        return afterFirstDot.substring(0, dot).trim();
    }

    private String extractDisplayerName(String identifier) {
        int dot = identifier.indexOf(46);
        if (dot == -1 || dot + 1 == identifier.length()) {
            return "";
        }
        String afterFirstDot = identifier.substring(dot + 1);
        if ((dot = afterFirstDot.indexOf(46)) == -1 || dot + 1 == afterFirstDot.length()) {
            return "default";
        }
        return afterFirstDot.substring(dot + 1).trim();
    }

    private Field constructField(Class<?> fieldClass) throws FormException {
        try {
            Constructor<?> constructor = fieldClass.getConstructor(new Class[0]);
            return (Field)constructor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new FormFatalException(e);
        }
    }

    private FieldDisplayer<? extends Field> constructDisplayer(Class<FieldDisplayer<? extends Field>> displayerClass) throws FormException {
        try {
            Constructor<FieldDisplayer<? extends Field>> constructor = displayerClass.getConstructor(new Class[0]);
            return constructor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new FormFatalException(e);
        }
    }

    private Class<? extends Field> getFieldClass(String fieldClassName) throws FormException {
        try {
            Class<?> fieldClass = Class.forName(fieldClassName);
            this.constructField(fieldClass);
            return fieldClass;
        }
        catch (ClassNotFoundException e) {
            throw new FormFatalException(e);
        }
    }

    private Class<FieldDisplayer<? extends Field>> getDisplayerClass(String displayerClassName) throws FormException {
        try {
            Class<FieldDisplayer<? extends Field>> displayerClass = Class.forName(displayerClassName);
            this.constructDisplayer(displayerClass);
            return displayerClass;
        }
        catch (ClassNotFoundException e) {
            throw new FormFatalException(e);
        }
    }

    private void init() throws FormException {
        try {
            SettingBundle properties = ResourceLocator.getSettingBundle((String)"org.silverpeas.form.settings.types");
            Set binds = properties.keySet();
            for (String identifier : binds) {
                String className = properties.getString(identifier);
                String typeName = this.extractTypeName(identifier);
                String classKind = this.extractClassKind(identifier);
                String displayerName = this.extractDisplayerName(identifier);
                if ("implementation".equals(classKind)) {
                    this.setFieldImplementation(className, typeName);
                    continue;
                }
                if (!"displayer".equals(classKind)) continue;
                this.setDisplayer(className, typeName, displayerName, "default".equals(displayerName));
            }
        }
        catch (Exception e) {
            throw new FormFatalException(e);
        }
    }
}

