/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.contribution.attachment.process;

import java.util.EnumSet;
import org.silverpeas.core.ResourceReference;
import org.silverpeas.core.contribution.attachment.model.DocumentType;
import org.silverpeas.core.contribution.attachment.model.SimpleDocument;
import org.silverpeas.core.process.io.file.AbstractDummyHandledFile;

public class SimpleDocumentDummyHandledFile
extends AbstractDummyHandledFile {
    private static final EnumSet<DocumentType> technicalDocumentTypes = EnumSet.of(DocumentType.wysiwyg);
    private final SimpleDocument document;
    private final boolean deleted;
    private ResourceReference target = null;

    public SimpleDocumentDummyHandledFile(SimpleDocument document) {
        this(document, false);
    }

    public SimpleDocumentDummyHandledFile(SimpleDocument document, ResourceReference target) {
        this(document);
        this.target = target;
    }

    public SimpleDocumentDummyHandledFile(SimpleDocument document, boolean deleted) {
        this.document = document;
        this.deleted = deleted;
    }

    @Override
    public String getComponentInstanceId() {
        if (this.target != null) {
            return this.target.getInstanceId();
        }
        return this.document.getInstanceId();
    }

    @Override
    public String getPath() {
        return this.document.getAttachmentPath();
    }

    @Override
    public String getName() {
        return this.document.getFilename();
    }

    @Override
    public long getSize() {
        return this.document.getSize();
    }

    @Override
    public String getMimeType() {
        if (technicalDocumentTypes.contains((Object)this.document.getDocumentType())) {
            return this.document.getDocumentType().getName();
        }
        return this.document.getAttachment().getContentType();
    }

    @Override
    public boolean isDeleted() {
        return this.deleted;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}

