/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.calendar.repository;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.inject.Singleton;
import org.silverpeas.core.annotation.Repository;
import org.silverpeas.core.calendar.Calendar;
import org.silverpeas.core.calendar.repository.CalendarEventRepository;
import org.silverpeas.core.calendar.repository.CalendarRepository;
import org.silverpeas.core.persistence.datasource.repository.jpa.NamedParameters;
import org.silverpeas.core.persistence.datasource.repository.jpa.SilverpeasJpaEntityRepository;

@Singleton
@Repository
public class DefaultCalendarRepository
extends SilverpeasJpaEntityRepository<Calendar>
implements CalendarRepository {
    public List<Calendar> getByComponentInstanceId(String componentInstanceId) {
        return this.getByComponentInstanceIds(Collections.singleton(componentInstanceId));
    }

    public List<Calendar> getByComponentInstanceIds(Collection<String> componentInstanceIds) {
        NamedParameters parameters = this.newNamedParameters();
        return this.findByNamedQuery("calendarsByComponentInstanceIds", parameters.add("componentInstanceIds", componentInstanceIds));
    }

    public List<Calendar> getAllSynchronized() {
        return this.findByNamedQuery("synchronizedCalendars", this.newNamedParameters());
    }

    public void delete(List<Calendar> calendars) {
        this.deleteAllEventsIn(calendars);
        super.delete(calendars);
    }

    public long deleteById(Collection<String> calendarIds) {
        this.deleteAllEventsIn((List<Calendar>)this.getById(calendarIds));
        return super.deleteById(calendarIds);
    }

    public long deleteByComponentInstanceId(String componentInstanceId) {
        this.deleteAllEventsIn(this.getByComponentInstanceId(componentInstanceId));
        return super.deleteByComponentInstanceId(componentInstanceId);
    }

    private void deleteAllEventsIn(List<Calendar> calendars) {
        CalendarEventRepository eventRepository = CalendarEventRepository.get();
        for (Calendar calendar : calendars) {
            eventRepository.deleteAll(calendar);
        }
    }
}

