/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.calendar.notification;

import java.util.List;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.annotation.Bean;
import org.silverpeas.core.calendar.Attendee;
import org.silverpeas.core.calendar.AttendeeSet;
import org.silverpeas.core.calendar.CalendarEvent;
import org.silverpeas.core.calendar.PlannedOnCalendar;
import org.silverpeas.core.calendar.notification.AbstractNotifier;
import org.silverpeas.core.calendar.notification.AttendeeLifeCycleEventNotifier;
import org.silverpeas.core.calendar.notification.AttendeeNotificationBuilder;
import org.silverpeas.core.calendar.notification.CalendarEventLifeCycleEvent;
import org.silverpeas.core.calendar.notification.CalendarOperation;
import org.silverpeas.core.calendar.notification.LifeCycleEventSubType;
import org.silverpeas.core.calendar.notification.SubscriberNotificationBuilder;
import org.silverpeas.core.notification.user.client.constant.NotifAction;
import org.silverpeas.core.persistence.datasource.OperationContext;

@Bean
public class CalendarEventNotifier
extends AbstractNotifier<CalendarEventLifeCycleEvent> {
    public void onCreation(CalendarEventLifeCycleEvent event) {
        CalendarEvent created = (CalendarEvent)event.getTransition().getAfter();
        CalendarOperation attendeeOperation = created.isRecurrent() ? CalendarOperation.SINCE_ATTENDEE_ADDING : CalendarOperation.ATTENDEE_ADDING;
        List<Attendee> attendees = this.attendeesIn(created.asCalendarComponent());
        AttendeeNotificationBuilder attendeeNotificationBuilder = new AttendeeNotificationBuilder((PlannedOnCalendar)created, NotifAction.CREATE).immediately().from(this.getSender()).to(attendees).about(attendeeOperation, attendees);
        attendeeNotificationBuilder.build().send();
        new SubscriberNotificationBuilder(created, NotifAction.CREATE).from(this.getSender()).about(CalendarOperation.EVENT_CREATE).excludingUsersIds(attendeeNotificationBuilder.getUserIdsToNotify()).build().send();
    }

    public void onUpdate(CalendarEventLifeCycleEvent event) {
        CalendarEvent before = (CalendarEvent)event.getTransition().getBefore();
        CalendarEvent after = (CalendarEvent)event.getTransition().getAfter();
        if (after.isModifiedSince(before)) {
            CalendarOperation operation = after.isRecurrent() ? CalendarOperation.SINCE_EVENT_UPDATE : CalendarOperation.EVENT_UPDATE;
            AttendeeNotificationBuilder attendeeNotificationBuilder = new AttendeeNotificationBuilder((PlannedOnCalendar)after, NotifAction.UPDATE).immediately().from(this.getSender()).to(this.concernedAttendeesIn(before.asCalendarComponent())).about(operation);
            attendeeNotificationBuilder.build().send();
            new SubscriberNotificationBuilder(after, NotifAction.UPDATE).from(this.getSender()).about(operation).excludingUsersIds(attendeeNotificationBuilder.getUserIdsToNotify()).build().send();
        }
        if (after.getAttendees().isNotSameAs(before.getAttendees())) {
            LifeCycleEventSubType subType = after.isRecurrent() ? LifeCycleEventSubType.SINCE : LifeCycleEventSubType.SINGLE;
            AttendeeLifeCycleEventNotifier.notifyAttendees((LifeCycleEventSubType)subType, (PlannedOnCalendar)after, (AttendeeSet)before.getAttendees(), (AttendeeSet)after.getAttendees());
        }
    }

    public void onDeletion(CalendarEventLifeCycleEvent event) {
        CalendarEvent deleted = (CalendarEvent)event.getTransition().getBefore();
        CalendarOperation operation = deleted.isRecurrent() ? CalendarOperation.SINCE_EVENT_DELETION : CalendarOperation.EVENT_DELETION;
        new AttendeeNotificationBuilder((PlannedOnCalendar)deleted, NotifAction.DELETE).immediately().from(this.getSender()).to(this.concernedAttendeesIn(deleted.asCalendarComponent())).about(operation).build().send();
    }

    private User getSender() {
        return OperationContext.fromCurrentRequester().getUser();
    }
}

