/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.calendar;

import java.util.ArrayList;
import java.util.stream.Collectors;
import org.silverpeas.core.admin.component.model.ComponentInstPath;
import org.silverpeas.core.admin.component.model.SilverpeasComponentInstance;
import org.silverpeas.core.admin.service.OrganizationController;
import org.silverpeas.core.admin.space.model.SpacePath;
import org.silverpeas.core.calendar.Calendar;
import org.silverpeas.kernel.exception.NotFoundException;

public class CalendarPath
extends ArrayList<Calendar> {
    private static final long serialVersionUID = 6013424875452769996L;

    public static CalendarPath getPath(Calendar calendar) {
        CalendarPath path = new CalendarPath();
        path.add(calendar);
        return path;
    }

    private CalendarPath() {
        super(1);
    }

    public String format(String language) {
        return this.format(language, false);
    }

    public String format(String language, boolean absolutePath) {
        return this.format(language, absolutePath, " > ");
    }

    public String format(String language, boolean absolutePath, String pathSep) {
        if (this.isEmpty()) {
            return "";
        }
        Calendar calendar = (Calendar)this.get(0);
        if (calendar.isMain()) {
            ComponentInstPath instancePath = ComponentInstPath.getPath(calendar.getComponentInstanceId());
            return instancePath.format(language, absolutePath, pathSep);
        }
        String spaceId = OrganizationController.get().getComponentInstance(calendar.getComponentInstanceId()).map(SilverpeasComponentInstance::getSpaceId).orElseThrow(() -> new NotFoundException("space not found from instance id " + calendar.getComponentInstanceId()));
        SpacePath spacePath = SpacePath.getPath(spaceId);
        return spacePath.format(language, absolutePath, pathSep) + pathSep + this.stream().map(Calendar::getTitle).collect(Collectors.joining(pathSep));
    }
}

