/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.backgroundprocess;

import java.text.MessageFormat;
import javax.inject.Inject;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.backgroundprocess.BackgroundProcessLogger;
import org.silverpeas.core.backgroundprocess.BackgroundProcessTask;
import org.silverpeas.core.scheduler.Job;
import org.silverpeas.core.scheduler.JobExecutionContext;
import org.silverpeas.core.scheduler.Scheduler;
import org.silverpeas.core.scheduler.SchedulingInitializer;
import org.silverpeas.core.scheduler.trigger.JobTrigger;
import org.silverpeas.core.scheduler.trigger.TimeUnit;
import org.silverpeas.kernel.annotation.NonNull;

@Service
class BackgroundProcessJobInitializer
extends SchedulingInitializer {
    private static final String JOB_NAME = "BackgroundProcessJob";
    @Inject
    private Scheduler scheduler;
    private final Job job = new BackgroundProcessCleanerJob();

    BackgroundProcessJobInitializer() {
    }

    protected JobTrigger getTrigger() {
        return JobTrigger.triggerEvery((int)5, (TimeUnit)TimeUnit.MINUTE);
    }

    @NonNull
    protected String getCron() {
        return "";
    }

    @NonNull
    protected Job getJob() {
        return this.job;
    }

    protected boolean isSchedulingEnabled() {
        return true;
    }

    private static class BackgroundProcessCleanerJob
    extends Job {
        private BackgroundProcessCleanerJob() {
            super(BackgroundProcessJobInitializer.JOB_NAME);
        }

        public void execute(JobExecutionContext context) {
            BackgroundProcessLogger.get().debug(() -> MessageFormat.format("cleaning quietly background process task with {0} {0,choice, 1#context| 1<contexts} referenced", BackgroundProcessTask.synchronizedContexts.size()));
            BackgroundProcessTask.purgeContexts();
        }
    }
}

