/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.admin.user.notification.role;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.silverpeas.core.admin.BaseRightProfile;
import org.silverpeas.core.admin.service.AdminController;
import org.silverpeas.core.admin.user.model.ProfileInst;
import org.silverpeas.core.admin.user.notification.GroupUserLink;
import org.silverpeas.core.admin.user.notification.GroupUserLinkEvent;
import org.silverpeas.core.admin.user.notification.role.UserRoleChangeNotifier;
import org.silverpeas.core.admin.user.notification.role.UserRoleEvent;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.notification.system.CDIAfterSuccessfulTransactionResourceEventListener;
import org.silverpeas.core.notification.system.ResourceEvent;

@Service
class GroupUserUnlinkEventListener
extends CDIAfterSuccessfulTransactionResourceEventListener<GroupUserLinkEvent> {
    @Inject
    private UserRoleChangeNotifier notifier;
    @Inject
    private AdminController admin;

    GroupUserUnlinkEventListener() {
    }

    public void onDeletion(GroupUserLinkEvent event) {
        GroupUserLink link = (GroupUserLink)event.getTransition().getBefore();
        Map<String, Set<String>> profiles = this.findComponentInstancesGroupedByNotAnymorePlayedRole(link.getUserId(), link.getGroupId());
        profiles.forEach((key, value) -> {
            UserRoleEvent evt = UserRoleEvent.builderFor(ResourceEvent.Type.DELETION).role((String)key).userId(link.getUserId()).instanceIds((Collection<String>)value).build();
            this.notifier.notify(evt);
        });
    }

    private Map<String, Set<String>> findComponentInstancesGroupedByNotAnymorePlayedRole(String userId, String groupId) {
        Set userProfiles = Stream.of(this.admin.getProfileIds(userId)).map(this.admin::getProfileInst).collect(Collectors.toSet());
        return Stream.concat(Stream.of(groupId), this.admin.getPathToGroup(groupId).stream()).map(this.admin::getGroupById).filter(g -> !List.of(g.getUserIds()).contains(userId)).flatMap(g -> Stream.of(this.admin.getProfileIdsOfGroup(g.getId())).map(this.admin::getProfileInst).filter(p -> this.isNotInUserProfiles((ProfileInst)p, userProfiles)).filter(p -> this.isNotInOthersGroups(userId, g.getId(), p.getAllGroups()))).collect(Collectors.groupingBy(BaseRightProfile::getName, Collectors.mapping(this::getComponentInst, Collectors.toSet())));
    }

    private boolean isNotInUserProfiles(ProfileInst actualProfile, Set<ProfileInst> userProfiles) {
        return userProfiles.stream().filter(p -> p.getComponentFatherId() == actualProfile.getComponentFatherId()).noneMatch(p -> p.getName().equals(actualProfile.getName()));
    }

    private boolean isNotInOthersGroups(String userId, String groupId, List<String> groups) {
        return groups.stream().filter(g -> !g.equalsIgnoreCase(groupId)).map(g -> this.admin.getGroupById((String)g)).noneMatch(g -> List.of(g.getUserIds()).contains(userId));
    }

    private String getComponentInst(ProfileInst profileInst) {
        return this.admin.getComponentInst(String.valueOf(profileInst.getComponentFatherId())).getId();
    }
}

