/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.admin.space.quota;

import java.io.File;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Singleton;
import org.silverpeas.core.admin.quota.exception.QuotaException;
import org.silverpeas.core.admin.quota.model.Quota;
import org.silverpeas.core.admin.service.OrganizationController;
import org.silverpeas.core.admin.space.SpaceInst;
import org.silverpeas.core.admin.space.quota.AbstractSpaceQuotaService;
import org.silverpeas.core.admin.space.quota.DataStorageSpaceQuotaKey;
import org.silverpeas.core.admin.space.quota.DataStorageSpaceQuotaService;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.util.UnitUtil;
import org.silverpeas.core.util.file.FileRepositoryManager;
import org.silverpeas.core.util.memory.MemoryUnit;
import org.silverpeas.kernel.bundle.ResourceLocator;
import org.silverpeas.kernel.bundle.SettingBundle;

@Service
@Singleton
public class DefaultDataStorageSpaceQuotaService
extends AbstractSpaceQuotaService<DataStorageSpaceQuotaKey>
implements DataStorageSpaceQuotaService {
    private static final SettingBundle settings = ResourceLocator.getSettingBundle((String)"org.silverpeas.jobStartPagePeas.settings.jobStartPagePeasSettings");
    private static long dataStorageInPersonalSpaceQuotaDefaultMaxCount = settings.getLong("quota.personalspace.datastorage.default.maxCount", 0L);

    @Override
    public Quota get(DataStorageSpaceQuotaKey key) throws QuotaException {
        if (!this.isActivated()) {
            return new Quota();
        }
        if (key.getSpace().isPersonalSpace()) {
            Quota quota = new Quota();
            quota.setQuotaId(-1L);
            quota.setType(key.getQuotaType());
            quota.setResourceId(key.getResourceId());
            quota.setMaxCount(dataStorageInPersonalSpaceQuotaDefaultMaxCount);
            quota.setCount(this.getCurrentCount(key));
            return quota;
        }
        return super.get(key);
    }

    @Override
    protected DataStorageSpaceQuotaKey createKeyFrom(SpaceInst space) {
        return DataStorageSpaceQuotaKey.from(space);
    }

    @Override
    public long getCurrentCount(DataStorageSpaceQuotaKey key) {
        long currentCount = 0L;
        if (key.getSpace() != null) {
            List files = Stream.of(OrganizationController.get().getAllComponentIdsRecur(key.getSpace().getId())).map(i -> new File(FileRepositoryManager.getAbsolutePath(i))).filter(File::exists).collect(Collectors.toList());
            currentCount = FileRepositoryManager.getDirectorySize(files);
        }
        return currentCount;
    }

    @Override
    protected boolean isActivated() {
        return settings.getBoolean("quota.space.datastorage.activated", false);
    }

    static {
        if (dataStorageInPersonalSpaceQuotaDefaultMaxCount < 0L) {
            dataStorageInPersonalSpaceQuotaDefaultMaxCount = 0L;
        }
        dataStorageInPersonalSpaceQuotaDefaultMaxCount = UnitUtil.convertTo((long)dataStorageInPersonalSpaceQuotaDefaultMaxCount, (MemoryUnit)MemoryUnit.MB, (MemoryUnit)MemoryUnit.B);
    }
}

