/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.admin.space.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.silverpeas.core.admin.component.dao.CommonDAO;
import org.silverpeas.core.admin.space.SpaceInstLight;
import org.silverpeas.core.annotation.Repository;
import org.silverpeas.kernel.util.StringUtil;

@Repository
public class SpaceDAO
extends CommonDAO {
    private static final String SPACE_COLUMNS = "id,domainFatherId,name,description,spaceStatus,createdBy,firstPageType,firstPageExtraParam,orderNum,createTime,updateTime,removeTime,updatedBy,removedBy,lang,isInheritanceBlocked,look,displaySpaceFirst,isPersonal";
    private static final String QUERY_SORTED_ROOT_SPACE_IDS = "SELECT id FROM st_space WHERE domainFatherId IS NULL AND spacestatus IS NULL AND isPersonal IS NULL ORDER BY orderNum";
    private static final String QUERY_SORTED_SUB_SPACES = "select id,domainFatherId,name,description,spaceStatus,createdBy,firstPageType,firstPageExtraParam,orderNum,createTime,updateTime,removeTime,updatedBy,removedBy,lang,isInheritanceBlocked,look,displaySpaceFirst,isPersonal from st_space where domainFatherId = ?  and spacestatus is null order by orderNum";
    private static final String QUERY_GET_MANAGEABLE_SPACE_IDS_BY_USER = "SELECT st_spaceuserrole.spaceid FROM st_spaceuserrole_user_rel, st_spaceuserrole WHERE st_spaceuserrole_user_rel.spaceuserroleid = st_spaceuserrole.id AND st_spaceuserrole.rolename='Manager' AND st_spaceuserrole_user_rel.userid=?";

    public List<Integer> getRootSpaceIds(Connection con) throws SQLException {
        return this.getSpaceIdsByQuery(con, QUERY_SORTED_ROOT_SPACE_IDS);
    }

    public List<SpaceInstLight> getSubSpaces(Connection con, int spaceId) throws SQLException {
        ArrayList<SpaceInstLight> spaces = new ArrayList<SpaceInstLight>();
        try (PreparedStatement stmt = con.prepareStatement(QUERY_SORTED_SUB_SPACES);){
            stmt.setInt(1, spaceId);
            try (ResultSet rs = stmt.executeQuery();){
                while (rs.next()) {
                    spaces.add(this.fetchSpace(rs));
                }
            }
        }
        return spaces;
    }

    public List<Integer> getManageableSpaceIds(Connection con, String userId, List<String> groupIds) throws SQLException {
        HashSet<Integer> manageableSpaceIds = new HashSet<Integer>();
        if (StringUtil.isDefined((String)userId)) {
            manageableSpaceIds.addAll(this.getManageableSpaceIdsByUser(con, userId));
        }
        if (groupIds != null && !groupIds.isEmpty()) {
            manageableSpaceIds.addAll(this.getManageableSpaceIdsByGroups(con, groupIds));
        }
        return new ArrayList<Integer>(manageableSpaceIds);
    }

    private List<Integer> getManageableSpaceIdsByUser(Connection con, String userId) throws SQLException {
        ArrayList<Integer> spaceIds = new ArrayList<Integer>();
        try (PreparedStatement stmt = con.prepareStatement(QUERY_GET_MANAGEABLE_SPACE_IDS_BY_USER);){
            stmt.setInt(1, Integer.parseInt(userId));
            try (ResultSet rs = stmt.executeQuery();){
                while (rs.next()) {
                    spaceIds.add(rs.getInt(1));
                }
            }
        }
        return spaceIds;
    }

    private List<Integer> getManageableSpaceIdsByGroups(Connection con, List<String> groupIds) throws SQLException {
        String query = "SELECT st_spaceuserrole.spaceid FROM st_spaceuserrole_group_rel, st_spaceuserrole WHERE st_spaceuserrole_group_rel.spaceuserroleid = st_spaceuserrole.id AND st_spaceuserrole.rolename='Manager' AND st_spaceuserrole_group_rel.groupid IN (" + SpaceDAO.list2String(groupIds) + ")";
        return this.getSpaceIdsByQuery(con, query);
    }

    private List<Integer> getSpaceIdsByQuery(Connection con, String query) throws SQLException {
        ArrayList<Integer> spaceIds = new ArrayList<Integer>();
        try (PreparedStatement stmt = con.prepareStatement(query);
             ResultSet rs = stmt.executeQuery();){
            while (rs.next()) {
                spaceIds.add(rs.getInt(1));
            }
        }
        return spaceIds;
    }

    private SpaceInstLight fetchSpace(ResultSet rs) throws SQLException {
        SpaceInstLight space = new SpaceInstLight();
        space.setLocalId(rs.getInt("id"));
        space.setFatherId(rs.getInt("domainFatherId"));
        space.setName(rs.getString("name"));
        space.setOrderNum(rs.getInt("orderNum"));
        space.setLook(rs.getString("look"));
        space.setStatus(rs.getString("spaceStatus"));
        boolean isPersonalSpace = rs.getInt("isPersonal") == 1;
        space.setPersonalSpace(isPersonalSpace);
        boolean inheritanceBlocked = rs.getInt("isInheritanceBlocked") == 1;
        space.setInheritanceBlocked(inheritanceBlocked);
        return space;
    }
}

