/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.admin.space;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.Serializable;
import javax.annotation.Nonnull;
import org.silverpeas.core.admin.space.SpaceInst;
import org.silverpeas.core.clipboard.ClipboardSelection;
import org.silverpeas.core.clipboard.SilverpeasKeyData;
import org.silverpeas.core.index.indexing.model.IndexEntry;
import org.silverpeas.core.index.indexing.model.IndexEntryKey;
import org.silverpeas.core.util.URLUtil;

public class SpaceSelection
extends ClipboardSelection
implements Serializable {
    private static final long serialVersionUID = -1717229458481172945L;
    private static final String TYPE = "Space";
    public static final DataFlavor SpaceFlavor = new DataFlavor(SpaceInst.class, "Space");
    private final SpaceInst spaceInst;

    public SpaceSelection(SpaceInst space) {
        this.spaceInst = space;
        super.addFlavor(SpaceFlavor);
    }

    @Override
    @Nonnull
    public synchronized Object getTransferData(DataFlavor parFlavor) throws UnsupportedFlavorException {
        Object transferedData;
        try {
            transferedData = super.getTransferData(parFlavor);
        }
        catch (UnsupportedFlavorException e) {
            if (SpaceFlavor.equals(parFlavor)) {
                transferedData = this.spaceInst;
            }
            throw e;
        }
        return transferedData;
    }

    @Override
    public IndexEntry getIndexEntry() {
        IndexEntry indexEntry = new IndexEntry(new IndexEntryKey(this.spaceInst.getId(), TYPE, this.spaceInst.getId()));
        indexEntry.setTitle(this.spaceInst.getName());
        return indexEntry;
    }

    @Override
    public SilverpeasKeyData getKeyData() {
        SilverpeasKeyData keyData = new SilverpeasKeyData(this.spaceInst.getId());
        keyData.setTitle(this.spaceInst.getName());
        keyData.setAuthor(this.spaceInst.getCreatorUserId());
        keyData.setCreationDate(this.spaceInst.getCreationDate());
        keyData.setDesc(this.spaceInst.getDescription());
        keyData.setType(TYPE);
        keyData.setLink(URLUtil.getSimpleURL(0, this.spaceInst.getId()));
        return keyData;
    }
}

