/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.admin.service;

import java.util.LinkedHashMap;
import java.util.Map;
import org.silverpeas.core.admin.user.model.UserDetail;
import org.silverpeas.core.backgroundprocess.AbstractBackgroundProcessRequest;

class SyncOfUsersContext {
    private final String domainId;
    private final boolean threaded;
    private final boolean addUserIntoSilverpeas;
    private final boolean delUsersOnDiffSync;
    private final StringBuilder report = new StringBuilder(5000);
    private final Map<String, UserDetail> addedUsers = new LinkedHashMap<String, UserDetail>();
    private final Map<String, UserDetail> updatedUsers = new LinkedHashMap<String, UserDetail>();
    private final Map<String, UserDetail> removedUsers = new LinkedHashMap<String, UserDetail>();
    private final Map<String, UserDetail> restoredUsers = new LinkedHashMap<String, UserDetail>();
    private final Map<String, UserDetail> deletedUsers = new LinkedHashMap<String, UserDetail>();
    private AbstractBackgroundProcessRequest indexationBackgroundProcess;

    SyncOfUsersContext(String domainId, boolean threaded, boolean addUserIntoSilverpeas, boolean delUsersOnDiffSync) {
        this.domainId = domainId;
        this.threaded = threaded;
        this.addUserIntoSilverpeas = addUserIntoSilverpeas;
        this.delUsersOnDiffSync = delUsersOnDiffSync;
    }

    boolean isRemoveOperationToPerform() {
        return !this.threaded || this.delUsersOnDiffSync;
    }

    boolean isAddOperationToPerform() {
        return this.addUserIntoSilverpeas;
    }

    SyncOfUsersContext appendToReport(String reportPart) {
        this.report.append(reportPart);
        return this;
    }

    String getDomainId() {
        return this.domainId;
    }

    String getReport() {
        return this.report.toString();
    }

    Map<String, UserDetail> getAddedUsers() {
        return this.addedUsers;
    }

    Map<String, UserDetail> getUpdatedUsers() {
        return this.updatedUsers;
    }

    Map<String, UserDetail> getRemovedUsers() {
        return this.removedUsers;
    }

    Map<String, UserDetail> getRestoredUsers() {
        return this.restoredUsers;
    }

    Map<String, UserDetail> getDeletedUsers() {
        return this.deletedUsers;
    }

    AbstractBackgroundProcessRequest getIndexationBackgroundProcess() {
        return this.indexationBackgroundProcess;
    }

    void setIndexationBackgroundProcess(AbstractBackgroundProcessRequest indexationBackgroundProcess) {
        this.indexationBackgroundProcess = indexationBackgroundProcess;
    }
}

