/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.admin.service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.silverpeas.core.admin.space.SpaceProfileInst;
import org.silverpeas.core.admin.user.model.Group;
import org.silverpeas.core.admin.user.model.User;

public class SpaceProfile {
    private SpaceProfileInst profile;
    private final Set<String> inheritedUserIds = new HashSet<String>();
    private final Set<String> inheritedGroupIds = new HashSet<String>();

    public void setProfile(SpaceProfileInst profile) {
        this.profile = profile;
    }

    public List<String> getGroupIds() {
        if (this.profile == null) {
            return Collections.emptyList();
        }
        return this.profile.getAllGroups();
    }

    public List<String> getUserIds() {
        if (this.profile == null) {
            return Collections.emptyList();
        }
        return this.profile.getAllUsers();
    }

    public Set<String> getInheritedGroupIds() {
        return this.inheritedGroupIds;
    }

    public Set<String> getInheritedUserIds() {
        return this.inheritedUserIds;
    }

    public Set<String> getAllUserIds() {
        Set<String> ids = this.getInheritedUserIds();
        ids.addAll(this.getUserIds());
        return ids;
    }

    public Set<String> getAllGroupIds() {
        Set<String> ids = this.getInheritedGroupIds();
        ids.addAll(this.getGroupIds());
        return ids;
    }

    public Set<String> getAllUserIdsIncludingAllGroups() {
        Set<String> ids = this.getInheritedUserIds();
        for (String groupId : this.inheritedGroupIds) {
            ids.addAll(this.getAllUserIdsOfGroup(groupId));
        }
        ids.addAll(this.getUserIds());
        for (String groupId : this.getGroupIds()) {
            ids.addAll(this.getAllUserIdsOfGroup(groupId));
        }
        return ids;
    }

    private List<String> getAllUserIdsOfGroup(String groupId) {
        ArrayList<String> userIds = new ArrayList<String>();
        Group group = Group.getById((String)groupId);
        List users = group.getAllUsers();
        for (User user : users) {
            userIds.add(user.getId());
        }
        return userIds;
    }

    void addInheritedProfile(SpaceProfileInst profile) {
        if (profile != null) {
            this.inheritedUserIds.addAll(profile.getAllUsers());
            this.inheritedGroupIds.addAll(profile.getAllGroups());
        }
    }

    public boolean isEmpty() {
        boolean emptyProfile = this.profile == null || this.profile.getAllUsers().isEmpty() && this.profile.getAllGroups().isEmpty();
        return emptyProfile && this.inheritedUserIds.isEmpty() && this.inheritedGroupIds.isEmpty();
    }
}

