/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.admin.service;

import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.silverpeas.core.admin.service.OrganizationController;
import org.silverpeas.core.admin.space.SpaceInstLight;
import org.silverpeas.core.annotation.Bean;
import org.silverpeas.core.util.ServiceProvider;

@Bean
public class RemovedSpaceAndComponentInstanceChecker {
    @Inject
    private OrganizationController controller;
    private Map<String, Boolean> instanceIdCache;
    private Map<String, Boolean> spaceIdCache;

    public static RemovedSpaceAndComponentInstanceChecker create() {
        return (RemovedSpaceAndComponentInstanceChecker)ServiceProvider.getService(RemovedSpaceAndComponentInstanceChecker.class, (Annotation[])new Annotation[0]);
    }

    RemovedSpaceAndComponentInstanceChecker() {
    }

    @PostConstruct
    void init() {
        this.resetWithCacheSizeOf(null);
    }

    public RemovedSpaceAndComponentInstanceChecker resetWithCacheSizeOf(Integer cacheSize) {
        this.instanceIdCache = cacheSize != null ? new HashMap(cacheSize) : new HashMap();
        this.spaceIdCache = cacheSize != null ? new HashMap(cacheSize) : new HashMap();
        return this;
    }

    public boolean isRemovedComponentInstanceById(String instanceId) {
        return instanceId == null || this.instanceIdCache.computeIfAbsent(instanceId, s -> this.controller.getComponentInstance((String)s).map(i -> !i.isPersonal() && (i.isRemoved() || this.findAnyRemovedSpace(this.controller.getPathToComponent((String)s)))).orElse(true)) != false;
    }

    public boolean isRemovedSpaceById(String spaceId) {
        return spaceId == null || Optional.ofNullable(this.spaceIdCache.get(spaceId)).orElseGet(() -> Optional.of(spaceId).map(this.controller::getPathToSpace).filter(Predicate.not(List::isEmpty)).map(this::findAnyRemovedSpace).orElseGet(() -> this.spaceIdCache.computeIfAbsent(spaceId, i -> true))) != false;
    }

    private boolean findAnyRemovedSpace(Collection<SpaceInstLight> spaces) {
        return spaces.isEmpty() || spaces.stream().anyMatch(s -> this.spaceIdCache.computeIfAbsent(s.getId(), i -> s.isRemoved()));
    }
}

