/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.admin.service;

import java.time.LocalDate;
import java.util.Date;
import java.util.stream.Stream;
import org.silverpeas.core.admin.AdminSettings;
import org.silverpeas.core.admin.domain.model.Domain;
import org.silverpeas.core.admin.service.Administration;
import org.silverpeas.core.admin.service.OrganizationControllerProvider;
import org.silverpeas.core.admin.user.model.Group;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.scheduler.Job;
import org.silverpeas.core.scheduler.JobExecutionContext;
import org.silverpeas.core.scheduler.SchedulingInitializer;
import org.silverpeas.core.util.DateUtil;
import org.silverpeas.kernel.annotation.NonNull;
import org.silverpeas.kernel.logging.SilverLogger;

@Service
public class DeleteRemovedGroupsScheduler
extends SchedulingInitializer {
    protected static final String JOB_NAME = "DeleteRemovedGroupsJob";
    private final Job job = new DeleteRemovedGroupsJob();

    @NonNull
    protected String getCron() {
        return AdminSettings.getDeletionOfRemovedGroupsCron();
    }

    @NonNull
    protected Job getJob() {
        return this.job;
    }

    protected boolean isSchedulingEnabled() {
        return AdminSettings.isAutomaticDeletionOfRemovedGroupsEnabled();
    }

    private static class DeleteRemovedGroupsJob
    extends Job {
        DeleteRemovedGroupsJob() {
            super(DeleteRemovedGroupsScheduler.JOB_NAME);
        }

        public void execute(JobExecutionContext context) {
            if (AdminSettings.isAutomaticDeletionOfRemovedGroupsEnabled()) {
                Administration administration = Administration.get();
                Stream.concat(Stream.of("-1"), Stream.of(OrganizationControllerProvider.getOrganisationController().getAllDomains()).map(Domain::getId)).forEach(i -> {
                    try {
                        for (Group group : administration.getRemovedGroups((String)i)) {
                            LocalDate now;
                            LocalDate stateSaveDayDateWithDelay = DateUtil.toLocalDate((Date)group.getStateSaveDate()).plusDays(AdminSettings.getDeletionOfRemovedGroupsDayDelay());
                            if (!stateSaveDayDateWithDelay.isBefore(now = LocalDate.now()) && !stateSaveDayDateWithDelay.isEqual(now)) continue;
                            administration.deleteGroupById(group.getId());
                        }
                    }
                    catch (Exception e) {
                        SilverLogger.getLogger((Object)((Object)this)).error(e.getMessage(), (Throwable)e);
                    }
                });
            }
        }
    }
}

