/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.admin.service;

import java.time.LocalDate;
import java.util.Date;
import java.util.List;
import javax.inject.Inject;
import org.silverpeas.core.admin.AdminSettings;
import org.silverpeas.core.admin.component.model.ComponentInstLight;
import org.silverpeas.core.admin.service.AdminException;
import org.silverpeas.core.admin.service.Administration;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.scheduler.Job;
import org.silverpeas.core.scheduler.JobExecutionContext;
import org.silverpeas.core.scheduler.SchedulingInitializer;
import org.silverpeas.core.util.DateUtil;
import org.silverpeas.kernel.annotation.NonNull;
import org.silverpeas.kernel.logging.SilverLogger;

@Service
public class DeleteRemovedApplicationsScheduler
extends SchedulingInitializer {
    protected static final String JOB_NAME = "DeleteRemovedApplicationsJob";
    private final Job job = new DeleteRemovedApplicationsJob();
    @Inject
    private Administration admin;

    @NonNull
    protected String getCron() {
        return AdminSettings.getDeletionOfRemovedApplicationsCron();
    }

    @NonNull
    protected Job getJob() {
        return this.job;
    }

    protected boolean isSchedulingEnabled() {
        return AdminSettings.isAutomaticDeletionOfRemovedApplicationsEnabled();
    }

    private class DeleteRemovedApplicationsJob
    extends Job {
        DeleteRemovedApplicationsJob() {
            super(DeleteRemovedApplicationsScheduler.JOB_NAME);
        }

        public void execute(JobExecutionContext context) {
            if (AdminSettings.isAutomaticDeletionOfRemovedApplicationsEnabled()) {
                try {
                    List<ComponentInstLight> allRemovedApps = DeleteRemovedApplicationsScheduler.this.admin.getRemovedComponents();
                    LocalDate now = LocalDate.now();
                    for (ComponentInstLight removedApp : allRemovedApps) {
                        LocalDate stateSaveDayDateWithDelay = DateUtil.toLocalDate((Date)removedApp.getRemovalDate()).plusDays(AdminSettings.getDeletionOfRemovedSpacesDayDelay());
                        if (!stateSaveDayDateWithDelay.isBefore(now) && !stateSaveDayDateWithDelay.isEqual(now)) continue;
                        DeleteRemovedApplicationsScheduler.this.admin.deleteComponentInst(User.getSystemUser().getId(), removedApp.getId(), true);
                    }
                }
                catch (AdminException e) {
                    SilverLogger.getLogger((Object)((Object)this)).error(e.getMessage(), (Throwable)((Object)e));
                }
            }
        }
    }
}

