/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.admin.service;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.inject.Inject;
import javax.transaction.Transactional;
import org.silverpeas.core.admin.ProfiledObjectId;
import org.silverpeas.core.admin.component.model.ComponentInst;
import org.silverpeas.core.admin.component.model.ComponentInstLight;
import org.silverpeas.core.admin.component.model.PasteDetail;
import org.silverpeas.core.admin.component.model.WAComponent;
import org.silverpeas.core.admin.domain.model.Domain;
import org.silverpeas.core.admin.domain.model.DomainProperty;
import org.silverpeas.core.admin.quota.exception.QuotaException;
import org.silverpeas.core.admin.service.AdminException;
import org.silverpeas.core.admin.service.Administration;
import org.silverpeas.core.admin.service.GroupSynchronizationRule;
import org.silverpeas.core.admin.service.RightAssignationContext;
import org.silverpeas.core.admin.space.SpaceInst;
import org.silverpeas.core.admin.space.SpaceInstLight;
import org.silverpeas.core.admin.space.SpaceProfileInst;
import org.silverpeas.core.admin.user.model.Group;
import org.silverpeas.core.admin.user.model.GroupDetail;
import org.silverpeas.core.admin.user.model.GroupProfileInst;
import org.silverpeas.core.admin.user.model.ProfileInst;
import org.silverpeas.core.admin.user.model.UserDetail;
import org.silverpeas.core.admin.user.model.UserFull;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.util.ArrayUtil;
import org.silverpeas.kernel.logging.SilverLogger;
import org.silverpeas.kernel.util.StringUtil;

@Service
@Transactional
public class AdminController
implements Serializable {
    private static final long serialVersionUID = -1605341557688427460L;
    @Inject
    private Administration admin;

    protected AdminController() {
    }

    public void reloadCaches() {
        this.admin.reloadCache();
    }

    public SpaceInst getSpaceInstById(String sSpaceId) {
        try {
            return this.admin.getSpaceInstById(sSpaceId);
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error(e.getLocalizedMessage(), (Throwable)e);
            return null;
        }
    }

    public SpaceInstLight getSpaceInstLight(String sSpaceId) {
        try {
            return this.admin.getSpaceInstLightById(sSpaceId);
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error(e.getLocalizedMessage(), (Throwable)e);
            return null;
        }
    }

    public List<SpaceInstLight> getPathToComponent(String componentId) {
        try {
            return this.admin.getPathToComponent(componentId);
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error(e.getLocalizedMessage(), (Throwable)e);
            return Collections.emptyList();
        }
    }

    public List<SpaceInstLight> getPathToSpace(String spaceId, boolean includeTarget) {
        try {
            return this.admin.getPathToSpace(spaceId, includeTarget);
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error(e.getLocalizedMessage(), (Throwable)e);
            return Collections.emptyList();
        }
    }

    public String[] getUserManageableSpaceIds(String sUserId) {
        try {
            return this.admin.getUserManageableSpaceIds(sUserId);
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error(e.getLocalizedMessage(), (Throwable)e);
            return ArrayUtil.emptyStringArray();
        }
    }

    public String[] getUserManageableSpaceClientIds(String sUserId) {
        try {
            UserDetail user = this.admin.getUserDetail(sUserId);
            if (user.isAccessAdmin() || sUserId.equals("0")) {
                return this.admin.getClientSpaceIds(this.admin.getAllSpaceIds());
            }
            return this.admin.getClientSpaceIds(this.admin.getUserManageableSpaceIds(sUserId));
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error(e.getLocalizedMessage(), (Throwable)e);
            return ArrayUtil.emptyStringArray();
        }
    }

    public String addSpaceInst(SpaceInst spaceInst) {
        try {
            return this.admin.addSpaceInst(spaceInst.getCreatorUserId(), spaceInst);
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error(e.getLocalizedMessage(), (Throwable)e);
            return "";
        }
    }

    public String deleteSpaceInstById(UserDetail user, String sSpaceInstId, boolean definitive) {
        try {
            return this.admin.deleteSpaceInstById(user.getId(), sSpaceInstId, definitive);
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error(e.getLocalizedMessage(), (Throwable)e);
            return "";
        }
    }

    public String updateSpaceInst(SpaceInst spaceInstNew) {
        try {
            return this.admin.updateSpaceInst(spaceInstNew);
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error(e.getLocalizedMessage(), (Throwable)e);
            return "";
        }
    }

    public String[] getAllRootSpaceIds() {
        try {
            return this.admin.getAllRootSpaceIds();
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error(e.getLocalizedMessage(), (Throwable)e);
            return ArrayUtil.emptyStringArray();
        }
    }

    public String[] getAllSpaceIds() {
        try {
            return this.admin.getAllSpaceIds();
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error(e.getLocalizedMessage(), (Throwable)e);
            return ArrayUtil.emptyStringArray();
        }
    }

    public String[] getAllSpaceIds(String userId) {
        try {
            return this.admin.getAllSpaceIds(userId);
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error(e.getLocalizedMessage(), (Throwable)e);
            return ArrayUtil.emptyStringArray();
        }
    }

    public String[] getAllSubSpaceIds(String sDomainFatherId) {
        try {
            return this.admin.getAllSubSpaceIds(sDomainFatherId);
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error(e.getLocalizedMessage(), (Throwable)e);
            return ArrayUtil.emptyStringArray();
        }
    }

    public String[] getAllSubSpaceIds(String sDomainFatherId, String userId) {
        try {
            return this.admin.getAllSubSpaceIds(sDomainFatherId, userId);
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error(e.getLocalizedMessage(), (Throwable)e);
            return ArrayUtil.emptyStringArray();
        }
    }

    public void updateSpaceOrderNum(String sSpaceId, int orderNum) {
        try {
            this.admin.updateSpaceOrderNum(sSpaceId, orderNum);
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public void indexSpace(int spaceId) {
        this.admin.createSpaceIndex(spaceId);
    }

    public void deleteAllSpaceIndexes() {
        this.admin.deleteAllSpaceIndexes();
    }

    public void moveSpace(String spaceId, String fatherId) throws AdminException {
        this.admin.moveSpace(spaceId, fatherId);
    }

    public Map<String, WAComponent> getAllComponents() {
        try {
            return this.admin.getAllWAComponents();
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error(e.getLocalizedMessage(), (Throwable)e);
            return Collections.emptyMap();
        }
    }

    public ComponentInst getComponentInst(String sComponentId) {
        try {
            return this.admin.getComponentInst(sComponentId);
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error(e.getLocalizedMessage(), (Throwable)e);
            return null;
        }
    }

    public ComponentInstLight getComponentInstLight(String sComponentId) {
        try {
            return this.admin.getComponentInstLight(sComponentId);
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error(e.getLocalizedMessage(), (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String addComponentInst(ComponentInst componentInst) throws QuotaException {
        Object exception = null;
        try {
            String string = this.admin.addComponentInst(componentInst.getCreatorUserId(), componentInst);
            return string;
        }
        catch (QuotaException e) {
            exception = e;
            throw e;
        }
        catch (Exception e) {
            exception = e;
            String string = "";
            return string;
        }
        finally {
            if (exception != null) {
                SilverLogger.getLogger((Object)this).error(((Throwable)exception).getLocalizedMessage(), (Throwable)exception);
            }
        }
    }

    public String deleteComponentInst(UserDetail user, String sComponentId, boolean definitive) {
        try {
            return this.admin.deleteComponentInst(user.getId(), sComponentId, definitive);
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error(e.getLocalizedMessage(), (Throwable)e);
            return "";
        }
    }

    public String updateComponentInst(ComponentInst componentInst) {
        try {
            return this.admin.updateComponentInst(componentInst);
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error(e.getLocalizedMessage(), (Throwable)e);
            return "";
        }
    }

    public void moveComponentInst(String spaceId, String componentId, String idComponentBefore, ComponentInst[] componentInstances) throws AdminException {
        this.admin.moveComponentInst(spaceId, componentId, idComponentBefore, componentInstances);
    }

    public String[] getAvailCompoIds(String sClientSpaceId, String sUserId) {
        try {
            return this.admin.getAvailCompoIds(sClientSpaceId, sUserId);
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error(e.getLocalizedMessage(), (Throwable)e);
            return ArrayUtil.emptyStringArray();
        }
    }

    public boolean isComponentAvailable(String componentId, String userId) {
        try {
            return this.admin.isComponentAvailableToUser(componentId, userId);
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error(e.getLocalizedMessage(), (Throwable)e);
            return false;
        }
    }

    public boolean isSpaceAvailable(String userId, String spaceId) {
        try {
            return this.admin.isSpaceAvailable(userId, spaceId);
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error(e.getLocalizedMessage(), (Throwable)e);
            return false;
        }
    }

    public void setComponentPlace(String componentId, String idComponentBefore, ComponentInst[] brothersComponents) {
        try {
            this.admin.setComponentPlace(componentId, idComponentBefore, brothersComponents);
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public void indexComponent(String componentId) {
        this.admin.createComponentIndex(componentId);
    }

    public void deleteAllComponentIndexes() {
        this.admin.deleteAllComponentIndexes();
    }

    public List<SpaceInstLight> getRemovedSpaces() {
        try {
            return this.admin.getRemovedSpaces();
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error(e.getLocalizedMessage(), (Throwable)e);
            return Collections.emptyList();
        }
    }

    public List<ComponentInstLight> getRemovedComponents() {
        try {
            return this.admin.getRemovedComponents();
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error(e.getLocalizedMessage(), (Throwable)e);
            return Collections.emptyList();
        }
    }

    public void restoreSpaceFromBasket(String spaceId) {
        try {
            this.admin.restoreSpaceFromBasket(spaceId);
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public void restoreComponentFromBasket(String componentId) {
        try {
            this.admin.restoreComponentFromBasket(componentId);
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public String[] getAllProfilesNames(String sComponentName) {
        try {
            return this.admin.getAllProfilesNames(sComponentName);
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error(e.getLocalizedMessage(), (Throwable)e);
            return ArrayUtil.emptyStringArray();
        }
    }

    public ProfileInst getProfileInst(String sProfileId) {
        try {
            return this.admin.getProfileInst(sProfileId);
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error(e.getLocalizedMessage(), (Throwable)e);
            return null;
        }
    }

    public List<ProfileInst> getProfilesByObject(ProfiledObjectId objectId, String componentId) {
        try {
            return this.admin.getProfilesByObject(objectId, componentId);
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error(e.getLocalizedMessage(), (Throwable)e);
            return Collections.emptyList();
        }
    }

    public String[] getProfilesByObjectAndUserId(ProfiledObjectId objectRef, String componentId, String userId) {
        try {
            return this.admin.getProfilesByObjectAndUserId(objectRef, componentId, userId);
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error(e.getLocalizedMessage(), (Throwable)e);
            return ArrayUtil.emptyStringArray();
        }
    }

    public String addProfileInst(ProfileInst profileInst) {
        return this.addProfileInst(profileInst, null);
    }

    public String addProfileInst(ProfileInst profileInst, String userId) {
        try {
            return this.admin.addProfileInst(profileInst, userId);
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error(e.getLocalizedMessage(), (Throwable)e);
            return "";
        }
    }

    public String deleteProfileInst(String sProfileId) {
        return this.deleteProfileInst(sProfileId, null);
    }

    public String deleteProfileInst(String sProfileId, String userId) {
        try {
            return this.admin.deleteProfileInst(sProfileId, userId);
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error(e.getLocalizedMessage(), (Throwable)e);
            return "";
        }
    }

    public String updateProfileInst(ProfileInst profileInst) {
        return this.updateProfileInst(profileInst, null);
    }

    public String updateProfileInst(ProfileInst profileInst, String userId) {
        try {
            return this.admin.updateProfileInst(profileInst, userId);
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error(e.getLocalizedMessage(), (Throwable)e);
            return "";
        }
    }

    public String getProfileLabelByName(String sComponentName, String sProfileName, String lang) {
        try {
            return this.admin.getProfileLabelFromName(sComponentName, sProfileName, lang);
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error("cannot get profile label from component name ''{0}'' and profile name ''{1}'' ({2})", (Object[])new String[]{sComponentName, sProfileName, e.getLocalizedMessage()}, (Throwable)e);
            return "";
        }
    }

    public String[] getProfileIds(String sUserId) {
        try {
            return this.admin.getProfileIds(sUserId);
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error(e.getLocalizedMessage(), (Throwable)e);
            return ArrayUtil.emptyStringArray();
        }
    }

    public String[] getProfileIdsOfGroup(String sGroupId) {
        try {
            return this.admin.getProfileIdsOfGroup(sGroupId);
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error(e.getLocalizedMessage(), (Throwable)e);
            return ArrayUtil.emptyStringArray();
        }
    }

    public void assignRightsFromUserToUser(RightAssignationContext.MODE operationMode, String sourceUserId, String targetUserId, boolean nodeAssignRights, String authorId) throws AdminException {
        this.admin.assignRightsFromUserToUser(operationMode, sourceUserId, targetUserId, nodeAssignRights, authorId);
    }

    public void assignRightsFromUserToGroup(RightAssignationContext.MODE operationMode, String sourceUserId, String targetGroupId, boolean nodeAssignRights, String authorId) throws AdminException {
        this.admin.assignRightsFromUserToGroup(operationMode, sourceUserId, targetGroupId, nodeAssignRights, authorId);
    }

    public void assignRightsFromGroupToUser(RightAssignationContext.MODE operationMode, String sourceGroupId, String targetUserId, boolean nodeAssignRights, String authorId) throws AdminException {
        this.admin.assignRightsFromGroupToUser(operationMode, sourceGroupId, targetUserId, nodeAssignRights, authorId);
    }

    public void assignRightsFromGroupToGroup(RightAssignationContext.MODE operationMode, String sourceGroupId, String targetGroupId, boolean nodeAssignRights, String authorId) throws AdminException {
        this.admin.assignRightsFromGroupToGroup(operationMode, sourceGroupId, targetGroupId, nodeAssignRights, authorId);
    }

    public List<GroupDetail> getDirectGroupsOfUser(String userId) {
        try {
            return this.admin.getDirectGroupsOfUser(userId);
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error("cannot get direct group identifiers of userId ''{0}'' ({1})", (Object[])new String[]{userId, e.getLocalizedMessage()}, (Throwable)e);
            return Collections.emptyList();
        }
    }

    public String updateDomain(Domain theDomain) {
        try {
            return this.admin.updateDomain(theDomain);
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error(e.getLocalizedMessage(), (Throwable)e);
            return "";
        }
    }

    public Domain getDomain(String domainId) {
        try {
            return this.admin.getDomain(domainId);
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error("cannot get domain from identifier ''{0}'' ({1})", (Object[])new String[]{domainId, e.getLocalizedMessage()}, (Throwable)e);
            return null;
        }
    }

    public long getDomainActions(String domainId) {
        try {
            return this.admin.getDomainActions(domainId);
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error(e.getLocalizedMessage(), (Throwable)e);
            return 0L;
        }
    }

    public GroupDetail[] getRootGroupsOfDomain(String domainId) {
        try {
            return this.admin.getRootGroupsOfDomain(domainId);
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error(e.getLocalizedMessage(), (Throwable)e);
            return new GroupDetail[0];
        }
    }

    public UserDetail[] getAllUsersOfGroup(String groupId) {
        try {
            return this.admin.getAllUsersOfGroup(groupId);
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error(e.getLocalizedMessage(), (Throwable)e);
            return new UserDetail[0];
        }
    }

    public UserDetail[] getUsersOfDomain(String domainId) {
        try {
            return this.admin.getUsersOfDomain(domainId);
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error(e.getLocalizedMessage(), (Throwable)e);
            return new UserDetail[0];
        }
    }

    public String[] getUserIdsOfDomain(String domainId) {
        try {
            return this.admin.getUserIdsOfDomain(domainId);
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error(e.getLocalizedMessage(), (Throwable)e);
            return ArrayUtil.emptyStringArray();
        }
    }

    public Domain[] getAllDomains() {
        try {
            return this.admin.getAllDomains();
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error(e.getLocalizedMessage(), (Throwable)e);
            return new Domain[0];
        }
    }

    public SpaceProfileInst getSpaceProfileInst(String sSpaceProfileId) {
        try {
            return this.admin.getSpaceProfileInst(sSpaceProfileId);
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error(e.getLocalizedMessage(), (Throwable)e);
            return null;
        }
    }

    public String addSpaceProfileInst(SpaceProfileInst spaceProfileInst, String userId) {
        try {
            return this.admin.addSpaceProfileInst(spaceProfileInst, userId);
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error(e.getLocalizedMessage(), (Throwable)e);
            return "";
        }
    }

    public void deleteSpaceProfileInst(String sSpaceProfileId, String userId) {
        try {
            this.admin.deleteSpaceProfileInst(sSpaceProfileId, userId);
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public String updateSpaceProfileInst(SpaceProfileInst spaceProfileInst, String userId) {
        try {
            return this.admin.updateSpaceProfileInst(spaceProfileInst, userId);
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error(e.getLocalizedMessage(), (Throwable)e);
            return "";
        }
    }

    public Group[] getAllSubGroups(String groupId) {
        try {
            return this.admin.getAllSubGroups(groupId);
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error(e.getMessage(), (Throwable)e);
            return new Group[0];
        }
    }

    public String getGroupName(String sGroupId) {
        try {
            return this.admin.getGroupName(sGroupId);
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error("cannot get group name from identifier ''{0}'' ({1})", (Object[])new String[]{sGroupId, e.getLocalizedMessage()}, (Throwable)e);
            return "";
        }
    }

    public String[] getGroupManageableSpaceIds(String sGroupId) {
        try {
            return this.admin.getGroupManageableSpaceIds(sGroupId);
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error(e.getLocalizedMessage(), (Throwable)e);
            return ArrayUtil.emptyStringArray();
        }
    }

    public GroupProfileInst getGroupProfile(String groupId) {
        try {
            return this.admin.getGroupProfileInst(groupId);
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error(e.getLocalizedMessage(), (Throwable)e);
            return null;
        }
    }

    public void updateGroupProfile(GroupProfileInst profile) {
        try {
            this.admin.updateGroupProfileInst(profile);
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public UserDetail getUserDetail(String sId) {
        try {
            return this.admin.getUserDetail(sId);
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error("cannot get user data from identifier ''{0}'' ({1})", (Object[])new String[]{sId, e.getLocalizedMessage()}, (Throwable)e);
            return null;
        }
    }

    public UserFull getUserFull(String sUserId) {
        try {
            return this.admin.getUserFull(sUserId);
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error("cannot get full user data from identifier ''{0}'' ({1})", (Object[])new String[]{sUserId, e.getLocalizedMessage()}, (Throwable)e);
            return null;
        }
    }

    public UserFull getUserFull(String domainId, String specificId) {
        try {
            return this.admin.getUserFull(domainId, specificId);
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error("cannot get full user data from domainId ''{0}'' and specificId ''{1}'' ({2})", (Object[])new String[]{domainId, specificId, e.getLocalizedMessage()}, (Throwable)e);
            return null;
        }
    }

    public String getUserIdByLoginAndDomain(String sLogin, String sDomainId) {
        try {
            return this.admin.getUserIdByLoginAndDomain(sLogin, sDomainId);
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error("cannot get user identifier from login ''{0}'' and domainId ''{1}'' ({2})", (Object[])new String[]{sLogin, sDomainId, e.getLocalizedMessage()}, (Throwable)e);
            return null;
        }
    }

    public boolean isUserByLoginAndDomainExist(String login, String domainId) {
        try {
            String userId = this.admin.getUserIdByLoginAndDomain(login, domainId);
            return StringUtil.isDefined((String)userId);
        }
        catch (AdminException e) {
            return false;
        }
    }

    public UserDetail[] getUserDetails(String[] asUserIds) {
        try {
            if (asUserIds != null) {
                return this.admin.getUserDetails(asUserIds);
            }
            return new UserDetail[0];
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error(e.getLocalizedMessage(), (Throwable)e);
            return new UserDetail[0];
        }
    }

    public String addUser(UserDetail userDetail) {
        try {
            return this.admin.addUser(userDetail);
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error(e.getLocalizedMessage(), (Throwable)e);
            return "";
        }
    }

    public void blockUser(String userId) {
        try {
            this.admin.blockUser(userId);
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public void unblockUser(String userId) {
        try {
            this.admin.unblockUser(userId);
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public void deactivateUser(String userId) {
        try {
            this.admin.deactivateUser(userId);
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public void activateUser(String userId) {
        try {
            this.admin.activateUser(userId);
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public void setUserSensitiveData(String userId, boolean areSensitive) {
        try {
            this.admin.setUserSensitiveData(userId, areSensitive);
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public String deleteUser(String sUserId) {
        try {
            return this.admin.deleteUser(sUserId);
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error(e.getLocalizedMessage(), (Throwable)e);
            return "";
        }
    }

    public String restoreUser(String sUserId) {
        try {
            return this.admin.restoreUser(sUserId);
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error(e.getLocalizedMessage(), (Throwable)e);
            return "";
        }
    }

    public String removeUser(String sUserId) {
        try {
            return this.admin.removeUser(sUserId);
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error(e.getLocalizedMessage(), (Throwable)e);
            return "";
        }
    }

    public String updateUser(UserDetail userDetail) {
        try {
            return this.admin.updateUser(userDetail);
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error(e.getLocalizedMessage(), (Throwable)e);
            return "";
        }
    }

    public String updateSynchronizedUser(UserDetail userDetail) {
        try {
            return this.admin.updateUser(userDetail);
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error(e.getLocalizedMessage(), (Throwable)e);
            return "";
        }
    }

    public String updateUserFull(UserFull userFull) throws AdminException {
        return this.admin.updateUserFull(userFull);
    }

    public String authenticate(String sKey, String sSessionId, boolean isAppInMaintenance) {
        try {
            return this.admin.identify(sKey, sSessionId, isAppInMaintenance);
        }
        catch (Exception e) {
            return "-1";
        }
    }

    public void indexAllUsers() {
        try {
            this.admin.indexAllUsers();
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public GroupDetail getGroupById(String sGroupId) {
        try {
            return this.admin.getGroup(sGroupId);
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error(e.getLocalizedMessage(), (Throwable)e);
            return null;
        }
    }

    public List<String> getPathToGroup(String groupId) {
        try {
            return this.admin.getPathToGroup(groupId);
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error(e.getLocalizedMessage(), (Throwable)e);
            return Collections.emptyList();
        }
    }

    public GroupDetail getGroupByNameInDomain(String sGroupName, String sDomainFatherId) {
        try {
            return this.admin.getGroupByNameInDomain(sGroupName, sDomainFatherId);
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error(e.getLocalizedMessage(), (Throwable)e);
            return null;
        }
    }

    public String addGroup(GroupDetail group) {
        try {
            return this.admin.addGroup(group);
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error(e.getLocalizedMessage(), (Throwable)e);
            return "";
        }
    }

    public List<GroupDetail> getRemovedGroupsInDomain(String domainId) throws AdminException {
        return this.admin.getRemovedGroups(domainId);
    }

    public List<GroupDetail> restoreGroupById(String groupId) {
        try {
            return this.admin.restoreGroup(groupId);
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error(e.getLocalizedMessage(), (Throwable)e);
            return Collections.emptyList();
        }
    }

    public List<GroupDetail> removeGroupById(String groupId) {
        try {
            return this.admin.removeGroup(groupId);
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error(e.getLocalizedMessage(), (Throwable)e);
            return Collections.emptyList();
        }
    }

    public List<GroupDetail> deleteGroupById(String sGroupId) {
        try {
            return this.admin.deleteGroupById(sGroupId);
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error(e.getLocalizedMessage(), (Throwable)e);
            return Collections.emptyList();
        }
    }

    public String updateGroup(GroupDetail group) {
        try {
            return this.admin.updateGroup(group);
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error(e.getLocalizedMessage(), (Throwable)e);
            return "";
        }
    }

    public String copyGroup(GroupDetail group, String parentGroupId) {
        try {
            return this.admin.copyGroup(group, parentGroupId);
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error(e.getLocalizedMessage(), (Throwable)e);
            return "";
        }
    }

    public void moveGroup(GroupDetail group, String parentGroupId) {
        try {
            this.admin.moveGroup(group, parentGroupId);
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public void indexAllGroups() {
        try {
            this.admin.indexAllGroups();
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public String synchronizeSilverpeasWithDomain(String domainId) {
        try {
            return this.admin.synchronizeSilverpeasWithDomain(domainId);
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error(e.getLocalizedMessage(), (Throwable)e);
            return "Error has occurred";
        }
    }

    public String synchronizeUser(String userId) {
        try {
            return this.admin.synchronizeUser(userId, true, true);
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error(e.getLocalizedMessage(), (Throwable)e);
            return "";
        }
    }

    public String synchronizeImportUser(String domainId, String userLogin) {
        try {
            return this.admin.synchronizeImportUser(domainId, userLogin, true);
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error(e.getLocalizedMessage(), (Throwable)e);
            return "";
        }
    }

    public List<DomainProperty> getSpecificPropertiesToImportUsers(String domainId, String language) {
        try {
            return this.admin.getSpecificPropertiesToImportUsers(domainId, language);
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error(e.getLocalizedMessage(), (Throwable)e);
            return Collections.emptyList();
        }
    }

    public List<UserDetail> searchUsers(String domainId, Map<String, String> query) {
        try {
            return Arrays.asList(this.admin.searchUsers(domainId, query));
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error(e.getLocalizedMessage(), (Throwable)e);
            return Collections.emptyList();
        }
    }

    public String synchronizeRemoveUser(String userId) {
        try {
            return this.admin.synchronizeRemoveUser(userId);
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error(e.getLocalizedMessage(), (Throwable)e);
            return "";
        }
    }

    public String synchronizeGroup(String groupId) {
        try {
            return this.admin.synchronizeGroup(groupId, true);
        }
        catch (AdminException e) {
            SilverLogger.getLogger((Object)this).error(e.getLocalizedMessage(), (Throwable)((Object)e));
            if (e.getCause() instanceof GroupSynchronizationRule.RuleError) {
                GroupSynchronizationRule.RuleError error = (GroupSynchronizationRule.RuleError)e.getCause();
                if (error instanceof GroupSynchronizationRule.GroundRuleError) {
                    return error.getHandledMessage() + "|" + ((GroupSynchronizationRule.GroundRuleError)error).getBaseRulePart();
                }
                return error.getHandledMessage();
            }
            return "";
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error(e.getLocalizedMessage(), (Throwable)e);
            return "";
        }
    }

    public Result<String> synchronizeImportGroup(String domainId, String groupName) {
        try {
            return new Result<String>(this.admin.synchronizeImportGroup(domainId, groupName, null, true, false));
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error(e.getLocalizedMessage(), (Throwable)e);
            return new Result<String>("").withError(e);
        }
    }

    public String synchronizeRemoveGroup(String groupId) {
        try {
            return this.admin.synchronizeRemoveGroup(groupId);
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error(e.getLocalizedMessage(), (Throwable)e);
            return "";
        }
    }

    public void removeUserFromGroup(String sUserId, String sGroupId) {
        try {
            this.admin.removeUserFromGroup(sUserId, sGroupId);
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public void addUserInGroup(String sUserId, String sGroupId) {
        try {
            this.admin.addUserInGroup(sUserId, sGroupId);
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public String copyAndPasteComponent(PasteDetail pasteDetail) throws AdminException, QuotaException {
        return this.admin.copyAndPasteComponent(pasteDetail);
    }

    public String copyAndPasteSpace(PasteDetail pasteDetail) throws AdminException, QuotaException {
        return this.admin.copyAndPasteSpace(pasteDetail);
    }

    public boolean isDomainManagerUser(String userId, String domainId) {
        try {
            return this.admin.isDomainManagerUser(userId, domainId);
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error(e.getLocalizedMessage(), (Throwable)e);
            return false;
        }
    }

    public List<UserDetail> getRemovedUsersInDomain(String domainId) throws AdminException {
        return this.admin.getRemovedUsers(domainId);
    }

    public List<UserDetail> getDeletedUsersInDomain(String domainId) throws AdminException {
        return this.admin.getNonBlankedDeletedUsers(domainId);
    }

    public List<UserDetail> getUsersWithSensitiveData(String domainId) throws AdminException {
        return this.admin.getUsersWithSensitiveData(domainId);
    }

    public void blankDeletedUsers(String targetDomainId, List<String> userIds) throws AdminException {
        this.admin.blankDeletedUsers(targetDomainId, userIds);
    }

    public void disableDataSensitivity(String targetDomainId, List<String> userIds) throws AdminException {
        this.admin.disableDataSensitivity(targetDomainId, userIds);
    }

    public static class Result<T> {
        private final T value;
        private Exception exception;

        Result(T value) {
            this.value = value;
        }

        public Optional<T> getValue() {
            return Optional.ofNullable(this.value);
        }

        public Optional<Exception> getException() {
            return Optional.ofNullable(this.exception);
        }

        Result<T> withError(Exception error) {
            this.exception = error;
            return this;
        }
    }
}

