/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.admin.persistence;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.StringTokenizer;
import org.silverpeas.core.SilverpeasExceptionMessages;
import org.silverpeas.core.persistence.jdbc.AbstractTable;
import org.silverpeas.core.persistence.jdbc.DBUtil;
import org.silverpeas.kernel.util.StringUtil;

public abstract class Table<T>
extends AbstractTable<T> {
    private static final String GROUP_EXISTENCE = "select id from ST_Group where id = ?";
    private static final String USER_EXISTENCE = "select id from ST_User where id = ?";

    protected Table(String tableName) {
        super(tableName);
    }

    protected String getNotNullString(String sn) {
        if (!StringUtil.isDefined((String)sn)) {
            return "";
        }
        return sn;
    }

    protected static String aliasColumns(String rowAlias, String columnList) {
        StringBuilder result = new StringBuilder();
        StringTokenizer st = new StringTokenizer(columnList, ",");
        String separator = "";
        while (st.hasMoreTokens()) {
            String column = st.nextToken();
            result.append(separator);
            result.append(rowAlias);
            result.append('.');
            result.append(column);
            separator = ",";
        }
        return result.toString();
    }

    protected void checkUserExistence(int userId) throws SQLException {
        try (Connection connection = DBUtil.openConnection();
             PreparedStatement statement = connection.prepareStatement(USER_EXISTENCE);){
            statement.setInt(1, userId);
            try (ResultSet rs = statement.executeQuery();){
                if (!rs.next()) {
                    throw new SQLException(SilverpeasExceptionMessages.unknown((String)"user", (Object)String.valueOf(userId)));
                }
            }
        }
    }

    protected void checkGroupExistence(int groupId) throws SQLException {
        try (Connection connection = DBUtil.openConnection();
             PreparedStatement statement = connection.prepareStatement(GROUP_EXISTENCE);){
            statement.setInt(1, groupId);
            try (ResultSet rs = statement.executeQuery();){
                if (!rs.next()) {
                    throw new SQLException(SilverpeasExceptionMessages.unknown((String)"group", (Object)String.valueOf(groupId)));
                }
            }
        }
    }

    protected List<String> getIds(String query) throws SQLException {
        return this.getIds(query, null);
    }

    protected List<String> getIds(String query, int id) throws SQLException {
        return this.getIds(query, Collections.singletonList(id));
    }

    /*
     * Exception decompiling
     */
    protected List<String> getIds(String query, List<?> params) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    protected List<T> getRows(String query, List<?> params) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void performPrepareStatementParams(PreparedStatement ps, List<?> params) throws SQLException {
        int i = 1;
        if (params != null) {
            for (Object param : params) {
                if (param instanceof Integer) {
                    ps.setInt(i++, (Integer)param);
                    continue;
                }
                if (param instanceof String) {
                    ps.setString(i++, (String)param);
                    continue;
                }
                if (param instanceof Long) {
                    ps.setLong(i++, (Long)param);
                    continue;
                }
                if (param instanceof java.sql.Date) {
                    ps.setDate(i++, (java.sql.Date)param);
                    continue;
                }
                if (param instanceof Timestamp) {
                    ps.setTimestamp(i++, (Timestamp)param);
                    continue;
                }
                if (!(param instanceof Date)) continue;
                ps.setDate(i++, new java.sql.Date(((Date)param).getTime()));
            }
        }
    }

    /*
     * Loose catch block
     */
    protected int getCount(String tableName, String whereClause, String param) throws SQLException {
        String query = MessageFormat.format("select count(*) as nbResult from {0} where {1}", tableName, whereClause);
        try (Connection connection = DBUtil.openConnection();){
            int n;
            block23: {
                ResultSet rs;
                PreparedStatement select;
                block20: {
                    int n2;
                    block22: {
                        block21: {
                            select = connection.prepareStatement(query);
                            select.setString(1, param);
                            rs = select.executeQuery();
                            if (!rs.next()) break block20;
                            n2 = rs.getInt(1);
                            if (rs == null) break block21;
                            rs.close();
                        }
                        if (select == null) break block22;
                        select.close();
                    }
                    return n2;
                }
                try {
                    block24: {
                        if (rs != null) {
                            rs.close();
                        }
                        break block24;
                        {
                            catch (Throwable throwable) {
                                if (rs != null) {
                                    try {
                                        rs.close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                }
                                throw throwable;
                            }
                        }
                    }
                    n = 0;
                    if (select == null) break block23;
                }
                catch (Throwable throwable) {
                    if (select != null) {
                        try {
                            select.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    }
                    throw throwable;
                }
                select.close();
            }
            return n;
        }
    }

    /*
     * Loose catch block
     */
    protected int getCount(String tableName, String whereClause, int id, String param) throws SQLException {
        String query = MessageFormat.format("select count(*) as nbResult from {0} where {1}", tableName, whereClause);
        try (Connection connection = DBUtil.openConnection();){
            int n;
            block23: {
                ResultSet rs;
                PreparedStatement select;
                block20: {
                    int n2;
                    block22: {
                        block21: {
                            select = connection.prepareStatement(query);
                            select.setInt(1, id);
                            select.setString(2, param);
                            rs = select.executeQuery();
                            if (!rs.next()) break block20;
                            n2 = rs.getInt(1);
                            if (rs == null) break block21;
                            rs.close();
                        }
                        if (select == null) break block22;
                        select.close();
                    }
                    return n2;
                }
                try {
                    block24: {
                        if (rs != null) {
                            rs.close();
                        }
                        break block24;
                        {
                            catch (Throwable throwable) {
                                if (rs != null) {
                                    try {
                                        rs.close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                }
                                throw throwable;
                            }
                        }
                    }
                    n = 0;
                    if (select == null) break block23;
                }
                catch (Throwable throwable) {
                    if (select != null) {
                        try {
                            select.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    }
                    throw throwable;
                }
                select.close();
            }
            return n;
        }
    }

    protected List<String> getIds(ResultSet rs) throws SQLException {
        ArrayList<String> result = new ArrayList<String>();
        while (rs.next()) {
            result.add(String.valueOf(rs.getInt(1)));
        }
        return result;
    }

    protected int updateRelation(String query) throws SQLException {
        try (Connection connection = DBUtil.openConnection();){
            int n;
            block12: {
                PreparedStatement statement = connection.prepareStatement(query);
                try {
                    n = statement.executeUpdate();
                    if (statement == null) break block12;
                }
                catch (Throwable throwable) {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                statement.close();
            }
            return n;
        }
    }

    protected boolean addParamToQuery(Collection<Object> theVect, StringBuilder theQuery, String value, String column, boolean concatAndOr, String andOr) {
        if (value != null && value.length() > 0) {
            return this.addParamToQuery(theVect, theQuery, (Object)value, column, concatAndOr, andOr);
        }
        return concatAndOr;
    }

    protected boolean addParamToQuery(Collection<Object> theVect, StringBuilder theQuery, int value, String column, boolean concatAndOr, String andOr) {
        return this.addParamToQuery(theVect, theQuery, (Object)value, column, concatAndOr, andOr);
    }

    protected boolean addIdToQuery(Collection<Object> theVect, StringBuilder theQuery, int value, String column, boolean concatAndOr, String andOr) {
        if (value != -2) {
            return this.addParamToQuery(theVect, theQuery, value, column, concatAndOr, andOr);
        }
        return concatAndOr;
    }

    private boolean addParamToQuery(Collection<Object> theVect, StringBuilder theQuery, Object value, String column, boolean concatAndOr, String andOr) {
        if (concatAndOr) {
            theQuery.append(andOr);
        } else {
            theQuery.append(" where (");
        }
        if (value instanceof String) {
            theQuery.append("LOWER(").append(column).append(") LIKE LOWER(?)");
        } else {
            theQuery.append(column).append(" = ?");
        }
        theVect.add(value);
        return true;
    }
}

