/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.admin.persistence;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import javax.inject.Inject;
import org.silverpeas.core.SilverpeasExceptionMessages;
import org.silverpeas.core.admin.domain.synchro.SynchroDomainReport;
import org.silverpeas.core.admin.persistence.GroupUserRoleRow;
import org.silverpeas.core.admin.persistence.Table;
import org.silverpeas.core.admin.user.dao.GroupDAO;
import org.silverpeas.core.admin.user.dao.UserDAO;
import org.silverpeas.core.annotation.Repository;
import org.silverpeas.core.persistence.jdbc.DBUtil;
import org.silverpeas.kernel.util.StringUtil;

@Repository
public class GroupUserRoleTable
extends Table<GroupUserRoleRow> {
    private static final String SELECT = "select ";
    private static final String SELECT_COUNT_GROUPUSERROLE_USER_REL = "select count(*) from ST_GroupUserRole_User_Rel where userId = ? and groupUserRoleId = ?";
    private static final String GROUPUSERROLE_COLUMNS = "id,ST_GroupUserRole.groupId,roleName";
    private static final String SELECT_GROUPUSERROLE_BY_ID = "select id,ST_GroupUserRole.groupId,roleName from ST_GroupUserRole where id = ?";
    private static final String SELECT_GROUPUSERROLE_BY_GROUPID = "select id,ST_GroupUserRole.groupId,roleName from ST_GroupUserRole where groupId = ?";
    private static final String SELECT_USER_GROUPUSERROLES = "select id,ST_GroupUserRole.groupId,roleName from ST_GroupUserRole, ST_GroupUserRole_User_Rel where id = groupUserRoleId  and ST_GroupUserRole_User_Rel.userId = ?";
    private static final String SELECT_GROUP_GROUPUSERROLES = "select id,ST_GroupUserRole.groupId,roleName from ST_GroupUserRole, ST_GroupUserRole_Group_Rel where id = groupUserRoleId  and ST_GroupUserRole_Group_Rel.groupId = ?";
    private static final String INSERT_GROUPUSERROLE = "insert into ST_GroupUserRole(id,groupId,roleName) values (?,?,?)";
    private static final String DELETE_GROUPUSERROLE = "delete from ST_GroupUserRole where id = ?";
    private static final String INSERT_A_GROUPUSERROLE_USER_REL = "insert into ST_GroupUserRole_User_Rel(groupUserRoleId, userId) values(?,?)";
    private static final String DELETE_GROUPUSERROLE_USER_REL = "delete from ST_GroupUserRole_User_Rel where groupUserRoleId = ? and userId = ?";
    private static final String SELECT_COUNT_GROUPUSERROLE_GROUP_REL = "select count(*) from ST_GroupUserRole_Group_Rel where groupId = ? and groupUserRoleId = ?";
    private static final String INSERT_A_GROUPUSERROLE_GROUP_REL = "insert into ST_GroupUserRole_Group_Rel(groupUserRoleId, groupId) values(?,?)";
    private static final String DELETE_GROUPUSERROLE_GROUP_REL = "delete from ST_GroupUserRole_Group_Rel where groupUserRoleId = ? and groupId = ?";
    @Inject
    private GroupDAO groupDAO;
    @Inject
    private UserDAO userDAO;

    GroupUserRoleTable() {
        super("ST_GroupUserRole");
    }

    protected GroupUserRoleRow fetchGroupUserRole(ResultSet rs) throws SQLException {
        GroupUserRoleRow sur = new GroupUserRoleRow();
        sur.id = rs.getInt(1);
        sur.groupId = rs.getInt(2);
        sur.roleName = rs.getString(3);
        return sur;
    }

    public GroupUserRoleRow getGroupUserRole(int id) throws SQLException {
        return (GroupUserRoleRow)this.getUniqueRow(SELECT_GROUPUSERROLE_BY_ID, id);
    }

    public GroupUserRoleRow getGroupUserRoleByGroupId(int groupId) throws SQLException {
        return (GroupUserRoleRow)this.getUniqueRow(SELECT_GROUPUSERROLE_BY_GROUPID, groupId);
    }

    public GroupUserRoleRow[] getDirectGroupUserRolesOfUser(int userId) throws SQLException {
        List rows = this.getRows(SELECT_USER_GROUPUSERROLES, userId);
        return rows.toArray(new GroupUserRoleRow[rows.size()]);
    }

    public GroupUserRoleRow[] getDirectGroupUserRolesOfGroup(int groupId) throws SQLException {
        List rows = this.getRows(SELECT_GROUP_GROUPUSERROLES, groupId);
        return rows.toArray(new GroupUserRoleRow[rows.size()]);
    }

    public void createGroupUserRole(GroupUserRoleRow groupUserRole) throws SQLException {
        this.checkGroupExistence(groupUserRole.groupId);
        this.insertRow(INSERT_GROUPUSERROLE, groupUserRole);
    }

    protected void prepareInsert(String insertQuery, PreparedStatement insert, GroupUserRoleRow usr) throws SQLException {
        if (usr.id == -1) {
            usr.id = this.getNextId();
        }
        insert.setInt(1, usr.id);
        insert.setInt(2, usr.groupId);
        if (!StringUtil.isDefined((String)usr.roleName)) {
            usr.roleName = "useless";
        }
        insert.setString(3, usr.roleName);
    }

    protected void prepareUpdate(String updateQuery, PreparedStatement update, GroupUserRoleRow row) throws SQLException {
    }

    public void removeGroupUserRole(int id) throws SQLException {
        GroupUserRoleRow groupUserRole = this.getGroupUserRole(id);
        if (groupUserRole == null) {
            return;
        }
        try (Connection connection = DBUtil.openConnection();){
            List<String> userIds = this.userDAO.getDirectUserIdsByGroupUserRole(connection, String.valueOf(id), true);
            for (String userId : userIds) {
                this.removeUserFromGroupUserRole(Integer.parseInt(userId), id);
            }
            List<String> groupIds = this.groupDAO.getDirectGroupIdsByGroupUserRole(connection, String.valueOf(id), true);
            for (String groupId : groupIds) {
                this.removeGroupFromGroupUserRole(Integer.parseInt(groupId), id);
            }
            this.updateRelation(DELETE_GROUPUSERROLE, id);
        }
    }

    private boolean isUserDirectlyInRole(int userId, int groupUserRoleId) throws SQLException {
        int[] ids = new int[]{userId, groupUserRoleId};
        Integer result = this.getInteger(SELECT_COUNT_GROUPUSERROLE_USER_REL, ids);
        return result != null && result >= 1;
    }

    public void addUserInGroupUserRole(int userId, int groupUserRoleId) throws SQLException {
        if (this.isUserDirectlyInRole(userId, groupUserRoleId)) {
            return;
        }
        this.checkUserExistence(userId);
        GroupUserRoleRow groupUserRole = this.getGroupUserRole(groupUserRoleId);
        if (groupUserRole == null) {
            throw new SQLException(SilverpeasExceptionMessages.unknown((String)"group role", (Object)String.valueOf(groupUserRoleId)));
        }
        int[] params = new int[]{groupUserRoleId, userId};
        this.updateRelation(INSERT_A_GROUPUSERROLE_USER_REL, params);
    }

    public void removeUserFromGroupUserRole(int userId, int groupUserRoleId) throws SQLException {
        if (!this.isUserDirectlyInRole(userId, groupUserRoleId)) {
            throw new SQLException("user " + userId + " isn't in group role " + groupUserRoleId);
        }
        int[] params = new int[]{groupUserRoleId, userId};
        SynchroDomainReport.debug("GroupUserRoleTable.removeUserFromGroupUserRole()", "Retrait de l'utilisateur d'ID " + userId + " de role d'egroup d'ID " + groupUserRoleId + ", requ\u00eate : delete from ST_GroupUserRole_User_Rel where groupUserRoleId = ? and userId = ?");
        this.updateRelation(DELETE_GROUPUSERROLE_USER_REL, params);
    }

    private boolean isGroupDirectlyInRole(int groupId, int groupUserRoleId) throws SQLException {
        int[] ids = new int[]{groupId, groupUserRoleId};
        Integer result = this.getInteger(SELECT_COUNT_GROUPUSERROLE_GROUP_REL, ids);
        return result != null && result >= 1;
    }

    public void addGroupInGroupUserRole(int groupId, int groupUserRoleId) throws SQLException {
        if (this.isGroupDirectlyInRole(groupId, groupUserRoleId)) {
            return;
        }
        this.checkGroupExistence(groupId);
        GroupUserRoleRow groupUserRole = this.getGroupUserRole(groupUserRoleId);
        if (groupUserRole == null) {
            throw new SQLException(SilverpeasExceptionMessages.unknown((String)"group role", (Object)String.valueOf(groupUserRoleId)));
        }
        int[] params = new int[]{groupUserRoleId, groupId};
        this.updateRelation(INSERT_A_GROUPUSERROLE_GROUP_REL, params);
    }

    public void removeGroupFromGroupUserRole(int groupId, int groupUserRoleId) throws SQLException {
        if (!this.isGroupDirectlyInRole(groupId, groupUserRoleId)) {
            throw new SQLException("The group " + groupId + " isn't in group role " + groupUserRoleId);
        }
        int[] params = new int[]{groupUserRoleId, groupId};
        SynchroDomainReport.debug("GroupUserRoleTable.removeGroupFromGroupUserRole()", "Retrait du groupe d'ID " + groupId + " de l'espace d'ID " + groupUserRoleId + ", requ\u00eate : delete from ST_GroupUserRole_Group_Rel where groupUserRoleId = ? and groupId = ?");
        this.updateRelation(DELETE_GROUPUSERROLE_GROUP_REL, params);
    }

    protected GroupUserRoleRow fetchRow(ResultSet rs) throws SQLException {
        return this.fetchGroupUserRole(rs);
    }
}

