/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.admin.domain.synchro;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import org.silverpeas.core.admin.domain.synchro.SynchroDomainReport;
import org.silverpeas.kernel.logging.Level;
import org.silverpeas.kernel.logging.SilverLogger;

public class SynchroGroupReport {
    private static final String REPORT_NAME = "DomainGroupSynchro";
    private static final String REPORT_NAMESPACE = "silverpeas.core.admin.domain.synchro.group";
    private static final String LOG_FORMAT = "[{0}] {1}: {2}";
    private static final int STATE_NOSYNC = 0;
    private static final int STATE_WAITSTART = 1;
    private static final int STATE_STARTED = 2;
    private static final int STATE_ENDED = 3;
    private static Level level;
    private static List<String> messages;
    private static int state;

    private SynchroGroupReport() {
    }

    public static String getReportName() {
        return REPORT_NAME;
    }

    public static void setReportLevel(Level reportLevel) {
        level = reportLevel;
    }

    public static Level getReportLevel() {
        return level == null ? Level.WARNING : level;
    }

    private static synchronized void setState(int iStateCours) {
        if (state < 1 || iStateCours != 1) {
            state = iStateCours;
        }
    }

    public static synchronized int getState() {
        return state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getMessages() {
        String message = null;
        List<String> list = messages;
        synchronized (list) {
            if (!messages.isEmpty()) {
                message = messages.remove(0);
            }
        }
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void startSynchro() {
        List<String> list = messages;
        synchronized (list) {
            messages.clear();
        }
        SynchroGroupReport.setState(2);
        SynchroGroupReport.warn("SynchroGroupReport.startSynchro", "Synchronisation Start");
    }

    public static void stopSynchro() {
        SynchroGroupReport.warn("SynchroGroupReport.stopSynchro", "Synchronisation End");
        SynchroGroupReport.setState(3);
    }

    public static void reset() {
        SynchroGroupReport.setState(0);
    }

    public static void waitForStart() {
        SynchroGroupReport.setState(1);
    }

    public static void debug(String classe, String message) {
        if (SynchroGroupReport.isSynchroActive()) {
            SynchroGroupReport.addMessage(Level.DEBUG, SynchroGroupReport.msgFormat(Level.DEBUG, classe, message, null));
            SilverLogger.getLogger((String)REPORT_NAMESPACE).debug(LOG_FORMAT, new Object[]{SynchroGroupReport.getReportName(), classe, message});
        }
    }

    public static void debug(String classe, Supplier<String> msgSupplier) {
        if (SynchroGroupReport.isSynchroActive() && SynchroGroupReport.getReportLevel().value() >= Level.DEBUG.value()) {
            String msg = msgSupplier.get();
            SynchroGroupReport.addMessage(Level.DEBUG, SynchroGroupReport.msgFormat(Level.DEBUG, classe, msg, null));
            SilverLogger.getLogger((String)REPORT_NAMESPACE).debug(LOG_FORMAT, new Object[]{SynchroGroupReport.getReportName(), classe, msg});
        }
    }

    public static void info(String classe, String message) {
        if (SynchroGroupReport.isSynchroActive()) {
            SynchroGroupReport.addMessage(Level.INFO, SynchroGroupReport.msgFormat(Level.INFO, classe, message, null));
            SilverLogger.getLogger((String)REPORT_NAMESPACE).info(LOG_FORMAT, new Object[]{SynchroGroupReport.getReportName(), classe, message});
        }
    }

    public static void warn(String classe, String message) {
        if (SynchroGroupReport.isSynchroActive()) {
            SynchroGroupReport.addMessage(Level.WARNING, SynchroGroupReport.msgFormat(Level.WARNING, classe, message, null));
            SilverLogger.getLogger((String)REPORT_NAMESPACE).warn(LOG_FORMAT, new Object[]{SynchroGroupReport.getReportName(), classe, message});
        }
    }

    public static void error(String classe, String message, Throwable ex) {
        if (SynchroGroupReport.isSynchroActive()) {
            SynchroGroupReport.addMessage(Level.ERROR, SynchroGroupReport.msgFormat(Level.ERROR, classe, message, ex));
            SilverLogger.getLogger((String)REPORT_NAMESPACE).error(LOG_FORMAT, new Object[]{SynchroGroupReport.getReportName(), classe, message}, ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void addMessage(Level msgLevel, String msg) {
        if (msgLevel.value() >= SynchroGroupReport.getReportLevel().value()) {
            List<String> list = messages;
            synchronized (list) {
                messages.add(msg);
            }
        }
    }

    public static boolean isSynchroActive() {
        return state == 2;
    }

    static String msgFormat(Level level, String from, String msgToTrace, Throwable ex) {
        return SynchroDomainReport.msgFormat(level, from, msgToTrace, ex);
    }

    static {
        messages = Collections.synchronizedList(new ArrayList());
        state = 0;
    }
}

