/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.admin.domain.driver.sqldriver;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.silverpeas.core.admin.domain.driver.sqldriver.SQLSettings;
import org.silverpeas.core.admin.domain.model.DomainProperty;
import org.silverpeas.core.admin.service.AdminException;
import org.silverpeas.core.admin.user.constant.UserAccessLevel;
import org.silverpeas.core.admin.user.model.UserDetail;
import org.silverpeas.core.persistence.jdbc.DBUtil;
import org.silverpeas.core.persistence.jdbc.sql.JdbcSqlQuery;

public class SQLUserTable {
    private static final String WHERE = " where ";
    private static final String UPDATE = "update ";
    private static final String SET = " set ";
    private static final String EQUAL_TO_GIVEN_VALUE = " = ?,";
    private static final String SELECT = "select ";
    private static final String FROM = " from ";
    private static final String WHERE_ID_EQUAL_TO_GIVEN_VALUE = " where id = ?";
    private final SQLSettings drvSettings;

    SQLUserTable(SQLSettings ds) {
        this.drvSettings = ds;
    }

    public int createUser(Connection c, UserDetail user) throws AdminException {
        int n;
        block8: {
            String theQuery = "insert into " + this.drvSettings.getUserTableName() + "(" + this.getColumns() + ") values (?,?,?,?,?)";
            PreparedStatement statement = c.prepareStatement(theQuery);
            try {
                int nextId = DBUtil.getNextId((String)this.drvSettings.getUserTableName(), (String)this.drvSettings.getUserSpecificIdColumnName());
                statement.setInt(1, nextId);
                statement.setString(2, this.drvSettings.trunc(user.getFirstName(), 100));
                statement.setString(3, this.drvSettings.trunc(user.getLastName(), 100));
                statement.setString(4, this.drvSettings.trunc(user.getEmailAddress(), 100));
                statement.setString(5, this.drvSettings.trunc(user.getLogin(), 50));
                statement.executeUpdate();
                n = nextId;
                if (statement == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new AdminException(e.getMessage(), e);
                }
            }
            statement.close();
        }
        return n;
    }

    public void deleteUser(Connection c, int userId) throws AdminException {
        String theQuery = "delete from " + this.drvSettings.getUserTableName() + WHERE + this.drvSettings.getUserSpecificIdColumnName() + " = ?";
        try (PreparedStatement statement = c.prepareStatement(theQuery);){
            statement.setInt(1, userId);
            statement.executeUpdate();
        }
        catch (Exception e) {
            throw new AdminException(e.getMessage(), e);
        }
    }

    public void updateUser(Connection c, UserDetail ud) throws AdminException {
        String theQuery = UPDATE + this.drvSettings.getUserTableName() + SET + this.drvSettings.getUserFirstNameColumnName() + EQUAL_TO_GIVEN_VALUE + this.drvSettings.getUserLastNameColumnName() + EQUAL_TO_GIVEN_VALUE + this.drvSettings.getUserEMailColumnName() + EQUAL_TO_GIVEN_VALUE + this.drvSettings.getUserLoginColumnName() + " = ?  where " + this.drvSettings.getUserSpecificIdColumnName() + " = ?";
        try (PreparedStatement statement = c.prepareStatement(theQuery);){
            statement.setString(1, this.drvSettings.trunc(ud.getFirstName(), 100));
            statement.setString(2, this.drvSettings.trunc(ud.getLastName(), 100));
            statement.setString(3, this.drvSettings.trunc(ud.getEmailAddress(), 100));
            statement.setString(4, this.drvSettings.trunc(ud.getLogin(), 50));
            statement.setInt(5, Integer.parseInt(ud.getSpecificId()));
            statement.executeUpdate();
        }
        catch (Exception e) {
            throw new AdminException(e.getMessage(), e);
        }
    }

    void updateUserSpecificProperty(Connection c, int userId, DomainProperty dp, String value) throws AdminException {
        String theQuery = UPDATE + this.drvSettings.getUserTableName() + SET + dp.getMapParameter() + " = ? where " + this.drvSettings.getUserSpecificIdColumnName() + " = ?";
        try (PreparedStatement statement = c.prepareStatement(theQuery);){
            if ("BOOLEAN".equals(dp.getType())) {
                statement.setInt(1, Integer.parseInt(value));
            } else {
                statement.setString(1, value);
            }
            statement.setInt(2, userId);
            statement.executeUpdate();
        }
        catch (Exception e) {
            throw new AdminException(e.getMessage(), e);
        }
    }

    void updateUserPassword(Connection c, int userId, String value) throws AdminException {
        if (this.drvSettings.isUserPasswordAvailable()) {
            String theQuery = UPDATE + this.drvSettings.getUserTableName() + SET + this.drvSettings.getUserPasswordColumnName() + " = ? where " + this.drvSettings.getUserSpecificIdColumnName() + " = ?";
            try (PreparedStatement statement = c.prepareStatement(theQuery);){
                statement.setString(1, value);
                statement.setInt(2, userId);
                statement.executeUpdate();
            }
            catch (Exception e) {
                throw new AdminException(e.getMessage(), e);
            }
        }
    }

    void updateUserPasswordValid(Connection c, int userId, boolean value) throws AdminException {
        if (this.drvSettings.isUserPasswordValidAvailable()) {
            String theQuery = UPDATE + this.drvSettings.getUserTableName() + SET + this.drvSettings.getUserPasswordValidColumnName() + " = ? where " + this.drvSettings.getUserSpecificIdColumnName() + " = ?";
            try (PreparedStatement statement = c.prepareStatement(theQuery);){
                statement.setString(1, value ? "Y" : "N");
                statement.setInt(2, userId);
                statement.executeUpdate();
            }
            catch (Exception e) {
                throw new AdminException(e.getMessage(), e);
            }
        }
    }

    public List<Integer> getAllUserIds(Connection c) throws AdminException {
        ArrayList<Integer> theResult = new ArrayList<Integer>();
        String theQuery = SELECT + this.drvSettings.getUserSpecificIdColumnName() + FROM + this.drvSettings.getUserTableName();
        try (PreparedStatement statement = c.prepareStatement(theQuery);
             ResultSet rs = statement.executeQuery();){
            while (rs.next()) {
                theResult.add(rs.getInt(1));
            }
        }
        catch (SQLException e) {
            throw new AdminException(e.getMessage(), e);
        }
        return theResult;
    }

    public List<UserDetail> getAllUsers(Connection c) throws AdminException {
        ArrayList<UserDetail> theResult = new ArrayList<UserDetail>();
        String theQuery = SELECT + this.getColumns() + FROM + this.drvSettings.getUserTableName();
        try (PreparedStatement statement = c.prepareStatement(theQuery);
             ResultSet rs = statement.executeQuery();){
            while (rs.next()) {
                theResult.add(this.fetchUser(rs));
            }
        }
        catch (SQLException e) {
            throw new AdminException(e.getMessage(), e);
        }
        return theResult;
    }

    public List<UserDetail> getUsersBySpecificProperty(Connection c, String propertyName, String value) throws AdminException {
        ArrayList<UserDetail> theResult = new ArrayList<UserDetail>();
        String theQuery = SELECT + this.getColumns() + FROM + this.drvSettings.getUserTableName() + " where lower(" + propertyName + ") like lower(?) ";
        try (PreparedStatement statement = c.prepareStatement(theQuery);){
            statement.setString(1, value);
            try (ResultSet rs = statement.executeQuery();){
                while (rs.next()) {
                    theResult.add(this.fetchUser(rs));
                }
            }
        }
        catch (SQLException e) {
            throw new AdminException(e.getMessage(), e);
        }
        return theResult;
    }

    public UserDetail getUser(Connection c, int userId) throws AdminException {
        return (UserDetail)JdbcSqlQuery.unique(this.getUsers(c, Collections.singleton(userId)));
    }

    public List<UserDetail> getUsers(Connection c, Collection<Integer> userIds) throws AdminException {
        try {
            return JdbcSqlQuery.streamBySplittingOn(userIds, idBatch -> JdbcSqlQuery.select((String)this.getColumns()).from(new String[]{this.drvSettings.getUserTableName()}).where("id", new Object[0]).in(idBatch).executeWith(c, this::fetchUser)).collect(Collectors.toList());
        }
        catch (SQLException e) {
            throw new AdminException(e.getMessage(), e);
        }
    }

    String getUserSpecificProperty(Connection c, int userId, DomainProperty dp) throws AdminException {
        String theQuery = SELECT + dp.getMapParameter() + FROM + this.drvSettings.getUserTableName() + WHERE_ID_EQUAL_TO_GIVEN_VALUE;
        return this.executeFieldQuery(c, theQuery, userId);
    }

    String getUserPassword(Connection c, int userId) throws AdminException {
        if (this.drvSettings.isUserPasswordAvailable()) {
            String theQuery = SELECT + this.drvSettings.getUserPasswordColumnName() + FROM + this.drvSettings.getUserTableName() + WHERE_ID_EQUAL_TO_GIVEN_VALUE;
            return this.executeFieldQuery(c, theQuery, userId);
        }
        return "";
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private String executeFieldQuery(Connection c, String theQuery, int userId) throws AdminException {
        try (PreparedStatement statement = c.prepareStatement(theQuery);){
            String string;
            block18: {
                ResultSet rs;
                block16: {
                    String string2;
                    block17: {
                        statement.setInt(1, userId);
                        rs = statement.executeQuery();
                        try {
                            if (!rs.next()) break block16;
                            string2 = rs.getString(1);
                            if (rs == null) break block17;
                        }
                        catch (Throwable throwable) {
                            if (rs != null) {
                                try {
                                    rs.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        rs.close();
                    }
                    return string2;
                }
                string = "";
                if (rs == null) break block18;
                rs.close();
            }
            return string;
        }
        catch (SQLException e) {
            throw new AdminException(e.getMessage(), e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    boolean getUserPasswordValid(Connection c, int userId) throws AdminException {
        if (this.drvSettings.isUserPasswordValidAvailable()) {
            String theQuery = SELECT + this.drvSettings.getUserPasswordValidColumnName() + FROM + this.drvSettings.getUserTableName() + WHERE_ID_EQUAL_TO_GIVEN_VALUE;
            try (PreparedStatement statement = c.prepareStatement(theQuery);){
                boolean bl;
                block19: {
                    ResultSet rs;
                    block17: {
                        boolean bl2;
                        block18: {
                            statement.setInt(1, userId);
                            rs = statement.executeQuery();
                            try {
                                if (!rs.next()) break block17;
                                bl2 = "Y".equalsIgnoreCase(rs.getString(1));
                                if (rs == null) break block18;
                            }
                            catch (Throwable throwable) {
                                if (rs != null) {
                                    try {
                                        rs.close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                }
                                throw throwable;
                            }
                            rs.close();
                        }
                        return bl2;
                    }
                    bl = this.drvSettings.isUserPasswordAvailable();
                    if (rs == null) break block19;
                    rs.close();
                }
                return bl;
            }
            catch (SQLException e) {
                throw new AdminException(e.getMessage(), e);
            }
        }
        return this.drvSettings.isUserPasswordAvailable();
    }

    protected String getColumns() {
        return this.drvSettings.getUserSpecificIdColumnName() + ", " + this.drvSettings.getUserFirstNameColumnName() + ", " + this.drvSettings.getUserLastNameColumnName() + ", " + this.drvSettings.getUserEMailColumnName() + ", " + this.drvSettings.getUserLoginColumnName();
    }

    private UserDetail fetchUser(ResultSet rs) throws SQLException {
        UserDetail u = new UserDetail();
        u.setSpecificId(Integer.toString(rs.getInt(1)));
        u.setFirstName(rs.getString(2));
        u.setLastName(rs.getString(3));
        u.setEmailAddress(rs.getString(4));
        u.setLogin(rs.getString(5));
        u.setAccessLevel(UserAccessLevel.USER);
        return u;
    }
}

