/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.admin.domain.driver.ldapdriver;

import com.novell.ldap.LDAPDN;
import com.novell.ldap.LDAPEntry;
import java.util.ArrayList;
import java.util.TreeMap;
import org.silverpeas.core.SilverpeasExceptionMessages;
import org.silverpeas.core.admin.domain.driver.ldapdriver.AbstractLDAPGroup;
import org.silverpeas.core.admin.domain.driver.ldapdriver.LDAPUtility;
import org.silverpeas.core.admin.service.AdminException;
import org.silverpeas.kernel.logging.SilverLogger;
import org.silverpeas.kernel.util.StringUtil;

public class LDAPGroupSubTree
extends AbstractLDAPGroup {
    private String[] getMemberGroupIds(String lds, String memberId, boolean isGroup) throws AdminException {
        ArrayList<String> groupEntries = new ArrayList<String>();
        LDAPEntry memberEntry = isGroup ? LDAPUtility.getFirstEntryFromSearch(lds, this.driverSettings.getLDAPUserBaseDN(), this.driverSettings.getScope(), this.driverSettings.getGroupsIdFilter(memberId), this.driverSettings.getGroupAttributes()) : LDAPUtility.getFirstEntryFromSearch(lds, this.driverSettings.getLDAPUserBaseDN(), this.driverSettings.getScope(), this.driverSettings.getUsersIdFilter(memberId), this.driverSettings.getGroupAttributes());
        if (memberEntry == null) {
            throw new AdminException(SilverpeasExceptionMessages.unknown((String)"LDAP group id", (Object)memberId), new String[0]);
        }
        String[] baseGroupDN = LDAPDN.explodeDN((String)this.driverSettings.getGroupsSpecificGroupsBaseDN(), (boolean)false);
        String[] memberDN = LDAPDN.explodeDN((String)memberEntry.getDN(), (boolean)false);
        if (memberDN.length - baseGroupDN.length > 1) {
            StringBuilder newDN = new StringBuilder();
            for (int i = 1; i < memberDN.length; ++i) {
                if (i > 1) {
                    newDN.append(",");
                }
                newDN.append(memberDN[i]);
            }
            LDAPEntry groupEntry = LDAPUtility.getFirstEntryFromSearch(lds, newDN.toString(), 0, this.driverSettings.getGroupsFullFilter(), this.driverSettings.getGroupAttributes());
            groupEntries.add(LDAPUtility.getFirstAttributeValue(groupEntry, this.driverSettings.getGroupsIdField()));
        }
        return groupEntries.toArray(new String[0]);
    }

    @Override
    public String[] getGroupMemberGroupIds(String lds, String groupId) throws AdminException {
        return this.getMemberGroupIds(lds, groupId, true);
    }

    @Override
    public String[] getUserMemberGroupIds(String lds, String userId) throws AdminException {
        return this.getMemberGroupIds(lds, userId, false);
    }

    @Override
    protected String[] getUserIds(String lds, LDAPEntry groupEntry) throws AdminException {
        LDAPEntry[] theEntries;
        ArrayList<String> userEntries = new ArrayList<String>();
        for (LDAPEntry theEntry : theEntries = LDAPUtility.search1000Plus(lds, groupEntry.getDN(), 1, this.driverSettings.getUsersFullFilter(), this.driverSettings.getUsersLoginField(), this.driverSettings.getGroupAttributes())) {
            String userSpecificId = this.getSpecificId(lds, theEntry);
            if (userSpecificId == null) continue;
            userEntries.add(userSpecificId);
        }
        return userEntries.toArray(new String[0]);
    }

    @Override
    protected LDAPEntry[] getChildGroupsEntry(String lds, String parentId, String extraFilter) throws AdminException {
        LDAPEntry parentEntry = null;
        try {
            if (parentId != null && !parentId.isEmpty()) {
                Object theFilter = extraFilter != null && !extraFilter.isEmpty() ? "(&" + extraFilter + this.driverSettings.getGroupsIdFilter(parentId) + ")" : this.driverSettings.getGroupsIdFilter(parentId);
                parentEntry = LDAPUtility.getFirstEntryFromSearch(lds, this.driverSettings.getLDAPUserBaseDN(), 2, (String)theFilter, this.driverSettings.getGroupAttributes());
            }
            return this.getChildGroupsEntryByLDAPEntry(lds, parentEntry);
        }
        catch (AdminException e) {
            if (this.synchroInProcess) {
                SilverLogger.getLogger((Object)this).warn((Throwable)((Object)e));
                this.append("PB getting Group's subgroups : ").append(parentId).append("\n");
                return new LDAPEntry[0];
            }
            throw e;
        }
    }

    private LDAPEntry[] getChildGroupsEntryByLDAPEntry(String lds, LDAPEntry parentEntry) throws AdminException {
        ArrayList<LDAPEntry> childGroupEntries = new ArrayList<LDAPEntry>();
        String searchDN = this.getSearchDN(parentEntry);
        LDAPEntry[] theEntries = LDAPUtility.search1000Plus(lds, searchDN, this.driverSettings.getScope(), this.driverSettings.getGroupsFullFilter(), this.driverSettings.getGroupsNameField(), this.driverSettings.getGroupAttributes());
        LDAPEntry[] sortedEntries = this.sortReversedDN(theEntries);
        String previousDN = "";
        for (LDAPEntry entry : sortedEntries) {
            boolean includeGroup;
            if (!this.notMatchSearchDN(entry, searchDN) || !this.notReachEndDN(entry, previousDN) || !(includeGroup = !this.driverSettings.getGroupsIncludeEmptyGroups() ? this.isIncludeGroup(lds, entry) : false)) continue;
            childGroupEntries.add(entry);
            previousDN = entry.getDN();
        }
        return childGroupEntries.toArray(new LDAPEntry[0]);
    }

    private boolean isIncludeGroup(String lds, LDAPEntry entry) {
        boolean includeGroup = true;
        try {
            LDAPEntry theFirstEntry = LDAPUtility.getFirstEntryFromSearch(lds, entry.getDN(), this.driverSettings.getScope(), this.driverSettings.getUsersFullFilter(), this.driverSettings.getGroupAttributes());
            if (theFirstEntry == null) {
                includeGroup = false;
            }
        }
        catch (AdminException e) {
            SilverLogger.getLogger((Object)this).error((Throwable)((Object)e));
        }
        return includeGroup;
    }

    private String getSearchDN(LDAPEntry parentEntry) {
        String searchDN = parentEntry == null ? this.driverSettings.getLDAPUserBaseDN() : parentEntry.getDN();
        return searchDN;
    }

    private boolean notReachEndDN(LDAPEntry entry, String previousDN) {
        return !entry.getDN().endsWith(previousDN) || StringUtil.isNotDefined((String)previousDN);
    }

    private boolean notMatchSearchDN(LDAPEntry entry, String searchDN) {
        return !entry.getDN().equalsIgnoreCase(searchDN);
    }

    private LDAPEntry[] sortReversedDN(LDAPEntry[] theEntries) {
        TreeMap<String, LDAPEntry> theMap = new TreeMap<String, LDAPEntry>();
        if (theEntries == null) {
            return new LDAPEntry[0];
        }
        for (int i = 0; i < theEntries.length; ++i) {
            LDAPEntry groupEntry = theEntries[i];
            StringBuilder forReversing = new StringBuilder(groupEntry.getDN());
            forReversing.reverse();
            theMap.put(forReversing.toString(), groupEntry);
        }
        return theMap.values().toArray(new LDAPEntry[0]);
    }
}

