/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.admin.domain.driver.ldapdriver;

import com.novell.ldap.LDAPAttribute;
import com.novell.ldap.LDAPConnection;
import com.novell.ldap.LDAPEntry;
import com.novell.ldap.LDAPModification;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.silverpeas.core.admin.domain.AbstractDomainDriver;
import org.silverpeas.core.admin.domain.driver.ldapdriver.AbstractLDAPGroup;
import org.silverpeas.core.admin.domain.driver.ldapdriver.LDAPSettings;
import org.silverpeas.core.admin.domain.driver.ldapdriver.LDAPSynchroCache;
import org.silverpeas.core.admin.domain.driver.ldapdriver.LDAPUser;
import org.silverpeas.core.admin.domain.driver.ldapdriver.LDAPUtility;
import org.silverpeas.core.admin.domain.model.DomainProperty;
import org.silverpeas.core.admin.service.AdminException;
import org.silverpeas.core.admin.user.model.GroupDetail;
import org.silverpeas.core.admin.user.model.UserDetail;
import org.silverpeas.core.admin.user.model.UserFull;
import org.silverpeas.core.persistence.jdbc.sql.JdbcSqlQuery;
import org.silverpeas.core.security.authentication.exception.AuthenticationBadCredentialException;
import org.silverpeas.kernel.bundle.SettingBundle;
import org.silverpeas.kernel.logging.SilverLogger;
import org.silverpeas.kernel.util.StringUtil;

public class LDAPDriver
extends AbstractDomainDriver {
    LDAPSynchroCache synchroCache = new LDAPSynchroCache();
    protected LDAPSettings driverSettings = new LDAPSettings();
    protected LDAPUser userTranslator = null;
    protected AbstractLDAPGroup groupTranslator = null;

    @Override
    public void initFromProperties(SettingBundle rs) throws AdminException {
        this.driverSettings.initFromProperties(rs);
        this.synchroCache.init(this.driverSettings);
        this.userTranslator = this.driverSettings.newLDAPUser();
        this.userTranslator.init(this.driverSettings, this, this.synchroCache);
        this.groupTranslator = this.driverSettings.newLDAPGroup();
        this.groupTranslator.init(this.driverSettings, this.synchroCache);
    }

    @Override
    public void addPropertiesToImport(List<DomainProperty> props) {
        this.addPropertiesToImport(props, null);
    }

    @Override
    public void addPropertiesToImport(List<DomainProperty> props, Map<String, String> descriptions) {
        props.add(this.getProperty("lastName", this.driverSettings.getUsersLastNameField(), descriptions));
        props.add(this.getProperty("firstName", this.driverSettings.getUsersFirstNameField(), descriptions));
        props.add(this.getProperty("email", this.driverSettings.getUsersEmailField(), descriptions));
        props.add(this.getProperty("login", this.driverSettings.getUsersLoginField(), descriptions));
    }

    private DomainProperty getProperty(String name, String mapParameter, Map<String, String> descriptions) {
        DomainProperty property = new DomainProperty();
        property.setName(name);
        property.setMapParameter(mapParameter);
        if (descriptions != null) {
            property.setDescription(descriptions.get(name));
        }
        return property;
    }

    @Override
    public long getDriverActions() {
        if (this.isX509Enabled()) {
            return 851463L;
        }
        return 818695L;
    }

    @Override
    public boolean isSynchroOnLoginEnabled() {
        return this.driverSettings.isSynchroAutomatic();
    }

    @Override
    public boolean isSynchroOnLoginRecursToGroups() {
        return this.driverSettings.isSynchroRecursToGroups();
    }

    @Override
    public boolean isGroupsInheritProfiles() {
        return this.driverSettings.isGroupsInheritProfiles();
    }

    @Override
    public boolean mustImportUsers() {
        return this.driverSettings.mustImportUsers();
    }

    @Override
    public boolean isSynchroThreaded() {
        return this.driverSettings.isSynchroThreaded();
    }

    @Override
    public void beginSynchronization() {
        this.setSynchroInProcess(true);
        this.synchroCache.beginSynchronization();
        this.userTranslator.beginSynchronization();
        this.groupTranslator.beginSynchronization();
    }

    public String endSynchronization() {
        StringBuilder report = new StringBuilder();
        this.synchroCache.endSynchronization();
        String result = this.userTranslator.endSynchronization();
        if (result != null && !result.isEmpty()) {
            report.append("LDAP Domain User specific errors :\n").append(result).append("\n\n");
        }
        if ((result = this.groupTranslator.endSynchronization()) != null && !result.isEmpty()) {
            report.append("LDAP Domain GroupDetail specific errors :\n").append(result).append("\n\n");
        }
        this.setSynchroInProcess(false);
        return report.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UserDetail importUser(String userLogin) throws AdminException {
        String ld = LDAPUtility.openConnection(this.driverSettings);
        try {
            UserDetail userDetail = this.userTranslator.getUserByLogin(ld, userLogin);
            return userDetail;
        }
        finally {
            LDAPUtility.closeConnection(ld);
        }
    }

    @Override
    public void removeUser(String userId) throws AdminException {
    }

    @Override
    public UserDetail synchroUser(String userId) throws AdminException {
        return this.getUser(userId);
    }

    @Override
    public String createUser(UserDetail user) throws AdminException {
        return null;
    }

    @Override
    public void deleteUser(String userId) throws AdminException {
    }

    @Override
    public void updateUserFull(UserFull user) throws AdminException {
        String ld = null;
        try {
            ld = LDAPUtility.openConnection(this.driverSettings);
            LDAPConnection connection = LDAPUtility.getConnection(ld);
            LDAPEntry theEntry = this.getUserLDAPEntry(ld, user.getSpecificId());
            if (theEntry == null) {
                throw new AuthenticationBadCredentialException("User not found: " + user.getSpecificId() + ";IdField=" + this.driverSettings.getUsersIdField(), new String[0]);
            }
            String userFullDN = theEntry.getDN();
            ArrayList<LDAPModification> modifications = new ArrayList<LDAPModification>();
            this.updateBasicData(user, modifications);
            this.preparePropertiesUpdate(ld, user, modifications);
            connection.modify(userFullDN, modifications.toArray(new LDAPModification[0]));
        }
        catch (Exception ex) {
            SilverLogger.getLogger((Object)this).error(ex.getMessage(), (Throwable)ex);
            throw new AdminException("LDAP access error", ex);
        }
        finally {
            try {
                if (ld != null) {
                    LDAPUtility.closeConnection(ld);
                }
            }
            catch (AdminException ex) {
                SilverLogger.getLogger((Object)this).error(ex.getMessage(), (Throwable)((Object)ex));
            }
        }
    }

    private void updateBasicData(UserFull user, List<LDAPModification> modifications) {
        LDAPAttribute attribute = this.getLDAPAttribute(this.driverSettings.getUsersFirstNameField(), user.getFirstName());
        modifications.add(new LDAPModification(2, attribute));
        attribute = this.getLDAPAttribute(this.driverSettings.getUsersLastNameField(), user.getLastName());
        modifications.add(new LDAPModification(2, attribute));
        attribute = this.getLDAPAttribute(this.driverSettings.getUsersEmailField(), user.getEmailAddress());
        modifications.add(new LDAPModification(2, attribute));
    }

    private void preparePropertiesUpdate(String ld, UserFull user, List<LDAPModification> modifications) throws AdminException {
        for (String propertyName : user.getPropertiesNames()) {
            DomainProperty property = user.getProperty(propertyName);
            if (property == null || !property.isUpdateAllowedToAdmin() && !property.isUpdateAllowedToUser()) continue;
            this.preparePropertyUpdate(ld, user, modifications, propertyName, property);
        }
    }

    private void preparePropertyUpdate(String ld, UserFull user, List<LDAPModification> modifications, String propertyName, DomainProperty property) throws AdminException {
        LDAPAttribute attribute;
        if (property.getType().equals("USERID")) {
            UserDetail anotherUser;
            LDAPEntry anotherUserEntry;
            String anotherUserId = user.getValue(propertyName);
            String anotherUserDN = null;
            if (StringUtil.isDefined((String)anotherUserId) && (anotherUserEntry = this.getUserLDAPEntry(ld, (anotherUser = UserDetail.getById(anotherUserId)).getSpecificId())) != null) {
                anotherUserDN = anotherUserEntry.getDN();
            }
            attribute = this.getLDAPAttribute(property.getMapParameter(), anotherUserDN);
        } else {
            attribute = this.getLDAPAttribute(property.getMapParameter(), user.getValue(propertyName));
        }
        modifications.add(new LDAPModification(2, attribute));
    }

    private LDAPEntry getUserLDAPEntry(String connection, String id) throws AdminException {
        return LDAPUtility.getFirstEntryFromSearch(connection, this.driverSettings.getLDAPUserBaseDN(), this.driverSettings.getScope(), this.driverSettings.getUsersIdFilter(id), this.driverSettings.getUserAttributes());
    }

    private LDAPAttribute getLDAPAttribute(String name, String value) {
        LDAPAttribute attribute = new LDAPAttribute(name);
        if (StringUtil.isDefined((String)value)) {
            attribute.addValue(value);
        }
        return attribute;
    }

    @Override
    public void updateUserDetail(UserDetail user) {
    }

    @Override
    public UserFull getUserFull(String specificId) throws AdminException {
        return (UserFull)JdbcSqlQuery.unique(this.listUserFulls(Collections.singleton(specificId)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<UserFull> listUserFulls(Collection<String> specificIds) throws AdminException {
        String ld = LDAPUtility.openConnection(this.driverSettings);
        try {
            List<UserFull> list = this.userTranslator.listUserFulls(ld, specificIds, this.getDomainId());
            return list;
        }
        finally {
            LDAPUtility.closeConnection(ld);
        }
    }

    @Override
    public UserDetail getUser(String specificId) throws AdminException {
        return (UserDetail)JdbcSqlQuery.unique(this.listUsers(Collections.singleton(specificId)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<UserDetail> listUsers(Collection<String> specificIds) throws AdminException {
        String ld = LDAPUtility.openConnection(this.driverSettings);
        try {
            List<UserDetail> list = this.userTranslator.listUsers(ld, specificIds);
            return list;
        }
        finally {
            LDAPUtility.closeConnection(ld);
        }
    }

    @Override
    public UserDetail[] getAllUsers() throws AdminException {
        String ld = LDAPUtility.openConnection(this.driverSettings);
        try {
            UserDetail[] userDetailArray = this.userTranslator.getAllUsers(ld, "");
            return userDetailArray;
        }
        finally {
            LDAPUtility.closeConnection(ld);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UserDetail[] getUsersBySpecificProperty(String propertyName, String propertyValue) throws AdminException {
        DomainProperty property = this.getProperty(propertyName);
        if (property == null) {
            return new UserDetail[0];
        }
        String ld = LDAPUtility.openConnection(this.driverSettings);
        try {
            String escapedPropertyValue = propertyValue;
            if (StringUtil.isDefined((String)propertyValue)) {
                String unescapedPropertyValue = LDAPUtility.unescapeLDAPSearchFilter(propertyValue);
                escapedPropertyValue = LDAPUtility.normalizeFilterValue(unescapedPropertyValue);
            }
            String extraFilter = "(" + property.getMapParameter() + "=" + escapedPropertyValue + ")";
            UserDetail[] userDetailArray = this.userTranslator.getAllUsers(ld, extraFilter);
            return userDetailArray;
        }
        finally {
            LDAPUtility.closeConnection(ld);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UserDetail[] getUsersByQuery(Map<String, String> query) throws AdminException {
        StringBuilder extraFilter = new StringBuilder();
        for (Map.Entry<String, String> property : query.entrySet()) {
            extraFilter.append("(").append(property.getKey()).append("=").append(property.getValue()).append(")");
        }
        String ld = LDAPUtility.openConnection(this.driverSettings);
        try {
            UserDetail[] userDetailArray = this.userTranslator.getAllUsers(ld, extraFilter.toString());
            return userDetailArray;
        }
        finally {
            LDAPUtility.closeConnection(ld);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getUserMemberGroupIds(String specificId) throws AdminException {
        String ld = LDAPUtility.openConnection(this.driverSettings);
        try {
            String[] stringArray = this.groupTranslator.getUserMemberGroupIds(ld, specificId);
            return stringArray;
        }
        finally {
            LDAPUtility.closeConnection(ld);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GroupDetail importGroup(String groupName) throws AdminException {
        String ld = LDAPUtility.openConnection(this.driverSettings);
        try {
            GroupDetail groupDetail = this.groupTranslator.getGroupByName(ld, groupName);
            return groupDetail;
        }
        finally {
            LDAPUtility.closeConnection(ld);
        }
    }

    @Override
    public void removeGroup(String groupId) throws AdminException {
    }

    @Override
    public GroupDetail synchroGroup(String groupId) throws AdminException {
        return this.getGroup(groupId);
    }

    @Override
    public String createGroup(GroupDetail group) throws AdminException {
        return null;
    }

    @Override
    public void deleteGroup(String groupId) throws AdminException {
    }

    @Override
    public void updateGroup(GroupDetail group) throws AdminException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GroupDetail getGroup(String specificId) throws AdminException {
        String ld = LDAPUtility.openConnection(this.driverSettings);
        try {
            GroupDetail groupDetail = this.groupTranslator.getGroup(ld, specificId);
            return groupDetail;
        }
        finally {
            LDAPUtility.closeConnection(ld);
        }
    }

    @Override
    public GroupDetail getGroupByName(String groupName) throws AdminException {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GroupDetail[] getGroups(String groupId) throws AdminException {
        String ld = LDAPUtility.openConnection(this.driverSettings);
        try {
            GroupDetail[] groupDetailArray = this.groupTranslator.getGroups(ld, groupId, "");
            return groupDetailArray;
        }
        finally {
            LDAPUtility.closeConnection(ld);
        }
    }

    @Override
    public GroupDetail[] getAllGroups() throws AdminException {
        String ld = LDAPUtility.openConnection(this.driverSettings);
        try {
            GroupDetail[] groupDetailArray = this.groupTranslator.getAllGroups(ld, "");
            return groupDetailArray;
        }
        finally {
            LDAPUtility.closeConnection(ld);
        }
    }

    @Override
    public GroupDetail[] getAllRootGroups() throws AdminException {
        String ld = LDAPUtility.openConnection(this.driverSettings);
        try {
            GroupDetail[] groupDetailArray = this.groupTranslator.getGroups(ld, null, "");
            return groupDetailArray;
        }
        finally {
            LDAPUtility.closeConnection(ld);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getGroupMemberGroupIds(String groupId) throws AdminException {
        String ld = LDAPUtility.openConnection(this.driverSettings);
        try {
            String[] stringArray = this.groupTranslator.getGroupMemberGroupIds(ld, groupId);
            return stringArray;
        }
        finally {
            LDAPUtility.closeConnection(ld);
        }
    }

    @Override
    public List<String> getUserAttributes() throws AdminException {
        return Arrays.asList(this.userTranslator.getUserAttributes());
    }

    @Override
    public void resetPassword(UserDetail user, String password) throws AdminException {
    }

    @Override
    public void resetEncryptedPassword(UserDetail user, String encryptedPassword) {
    }
}

