/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.admin.component.model;

import java.util.ArrayList;
import java.util.List;
import org.silverpeas.core.admin.component.model.LocalizedComponent;
import org.silverpeas.core.admin.component.model.LocalizedProfile;
import org.silverpeas.core.admin.component.model.Profile;
import org.silverpeas.core.admin.component.model.WAComponent;

public class LocalizedWAComponent
extends LocalizedComponent {
    private final WAComponent realComponent;

    public LocalizedWAComponent(WAComponent component, String lang) {
        super(component, lang);
        this.realComponent = component;
    }

    public List<LocalizedProfile> getProfiles() {
        ArrayList<LocalizedProfile> localizedProfiles = new ArrayList<LocalizedProfile>();
        for (Profile profile : this.realComponent.getProfiles()) {
            localizedProfiles.add(new LocalizedProfile(this, profile));
        }
        return localizedProfiles;
    }

    public LocalizedProfile getProfile(String name) {
        List<LocalizedProfile> profiles = this.getProfiles();
        for (LocalizedProfile profile : profiles) {
            if (!name.equals(profile.getName())) continue;
            return profile;
        }
        return null;
    }

    public String getRouter() {
        return this.realComponent.getRouter();
    }

    public String getSuite() {
        return this.getLocalized("suite", this.realComponent.getSuite());
    }

    public boolean isPortlet() {
        return this.realComponent.isPortlet();
    }

    public boolean isVisibleInPersonalSpace() {
        return this.realComponent.isVisibleInPersonalSpace();
    }
}

