/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.jcr.security;

import java.util.stream.Stream;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.kernel.util.StringUtil;

public abstract class JCRNode<T> {
    private final T node;

    protected JCRNode(T node) {
        this.node = node;
    }

    public boolean isFolder() {
        return "nt:folder".equals(this.getPrimaryType());
    }

    public boolean isFile() {
        return "nt:file".equals(this.getPrimaryType());
    }

    public boolean isLocked() {
        return this.getMixinTypes().anyMatch("slv:ownable"::equals);
    }

    public boolean isOwnedByUser(User user) {
        String owner = this.getProperty("slv:owner", 3);
        if (StringUtil.isDefined((String)owner)) {
            return user != null && user.getId().equals(owner);
        }
        return false;
    }

    public abstract String getPath();

    public abstract String getPrimaryType();

    public abstract Stream<String> getMixinTypes();

    public abstract String getProperty(String var1, int var2);

    protected T getNode() {
        return this.node;
    }
}

