/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.jcr.impl.oak.factories;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.text.MessageFormat;
import java.text.ParseException;
import java.time.Duration;
import java.time.Instant;
import org.apache.jackrabbit.oak.segment.file.FileStore;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.backgroundprocess.RunnableBackgroundProcess;
import org.silverpeas.core.jcr.impl.oak.configuration.SegmentNodeStoreConfiguration;
import org.silverpeas.core.scheduler.Job;
import org.silverpeas.core.scheduler.JobExecutionContext;
import org.silverpeas.core.scheduler.Scheduler;
import org.silverpeas.core.scheduler.SchedulerException;
import org.silverpeas.core.scheduler.SchedulerProvider;
import org.silverpeas.core.scheduler.trigger.JobTrigger;
import org.silverpeas.core.util.ServiceProvider;
import org.silverpeas.kernel.logging.SilverLogger;
import org.silverpeas.kernel.util.StringUtil;

@Service
public class SegmentNodeStoreCleaner {
    private static final String JOB_NAME = SegmentNodeStoreCleaner.class.getSimpleName();
    private Path segmentPath;
    private FileStore fs;
    private SegmentNodeStoreConfiguration parameters;

    public static SegmentNodeStoreCleaner get() {
        return (SegmentNodeStoreCleaner)ServiceProvider.getService(SegmentNodeStoreCleaner.class, (Annotation[])new Annotation[0]);
    }

    void initializeWith(Path segmentPath, FileStore fs, SegmentNodeStoreConfiguration parameters) throws ParseException, SchedulerException {
        this.segmentPath = segmentPath;
        this.fs = fs;
        this.parameters = parameters;
        if (StringUtil.isDefined((String)parameters.getCompactionCRON())) {
            this.setupCron();
        }
    }

    private void setupCron() throws ParseException, SchedulerException {
        Scheduler scheduler = SchedulerProvider.getVolatileScheduler();
        scheduler.scheduleJob((Job)new SegmentNodeStoreCleanerJob(), JobTrigger.triggerAt((String)this.parameters.getCompactionCRON()));
    }

    public void execute() {
        if (this.isEnabled()) {
            RunnableBackgroundProcess.register((String)JOB_NAME, () -> {
                this.fullGC();
                this.cleanBackupFiles();
            });
        } else {
            SilverLogger.getLogger((Object)this).warn("Trying to start a cleaning background process of the JCR, but the cleaner has not been initialized", new Object[0]);
        }
    }

    private boolean isEnabled() {
        return this.segmentPath != null && this.fs != null && this.parameters != null;
    }

    private void fullGC() {
        try {
            this.fs.fullGC();
        }
        catch (IOException e) {
            SilverLogger.getLogger((Object)this).error((Throwable)e);
        }
    }

    private void cleanBackupFiles() {
        int backupFileAgeThreshold = this.parameters.getBackupFileAgeThreshold();
        if (backupFileAgeThreshold >= 0) {
            try {
                BackupFileDeleter visitor = new BackupFileDeleter(backupFileAgeThreshold);
                Files.walkFileTree(this.segmentPath, visitor);
                SilverLogger.getLogger((Object)this).info(MessageFormat.format("{0} backup file(s) have been deleted.", visitor.getDeletionCount()), new Object[0]);
            }
            catch (IOException e) {
                SilverLogger.getLogger((Object)this).error((Throwable)e);
            }
        } else {
            SilverLogger.getLogger((Object)this).info(MessageFormat.format("Backup file deletion is not enabled.", new Object[0]), new Object[0]);
        }
    }

    private static class SegmentNodeStoreCleanerJob
    extends Job {
        public SegmentNodeStoreCleanerJob() {
            super(JOB_NAME);
        }

        public void execute(JobExecutionContext context) {
            SegmentNodeStoreCleaner.get().execute();
        }
    }

    private static class BackupFileDeleter
    extends SimpleFileVisitor<Path> {
        private final Instant now = Instant.now();
        private final int backupFileAgeThreshold;
        private int deletionCount = 0;

        public BackupFileDeleter(int backupFileAgeThreshold) {
            this.backupFileAgeThreshold = backupFileAgeThreshold;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            if (file.getFileName().toString().endsWith(".bak") && (this.backupFileAgeThreshold == 0 || Duration.between(attrs.lastModifiedTime().toInstant(), this.now).toDays() >= (long)this.backupFileAgeThreshold)) {
                Files.delete(file);
                ++this.deletionCount;
            }
            return super.visitFile(file, attrs);
        }

        public int getDeletionCount() {
            return this.deletionCount;
        }
    }
}

