/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.questionreply.service;

import java.util.Collection;
import java.util.List;
import org.silverpeas.components.questionreply.QuestionReplyException;
import org.silverpeas.components.questionreply.model.Question;
import org.silverpeas.components.questionreply.model.Recipient;
import org.silverpeas.components.questionreply.model.Reply;

public interface QuestionManager {
    public long createQuestion(Question var1) throws QuestionReplyException;

    public long createReply(Reply var1, Question var2) throws QuestionReplyException;

    public void closeQuestions(Collection<Long> var1) throws QuestionReplyException;

    public void openQuestions(Collection<Long> var1) throws QuestionReplyException;

    public void updateQuestionRecipients(Question var1) throws QuestionReplyException;

    public void updateQuestionRepliesPublicStatus(Collection<Long> var1) throws QuestionReplyException;

    public void updateQuestionRepliesPrivateStatus(Collection<Long> var1) throws QuestionReplyException;

    public void updateRepliesPublicStatus(Collection<Long> var1, Question var2) throws QuestionReplyException;

    public void updateRepliesPrivateStatus(Collection<Long> var1, Question var2) throws QuestionReplyException;

    public void updateQuestion(Question var1) throws QuestionReplyException;

    public void updateReply(Reply var1) throws QuestionReplyException;

    public void deleteQuestionAndReplies(Collection<Long> var1) throws QuestionReplyException;

    public List<Reply> getAllReplies(long var1, String var3) throws QuestionReplyException;

    public Question getQuestion(long var1) throws QuestionReplyException;

    public Question getQuestionAndReplies(long var1) throws QuestionReplyException;

    public List<Question> getQuestionsByIds(List<String> var1) throws QuestionReplyException;

    public List<Reply> getQuestionReplies(long var1, String var3) throws QuestionReplyException;

    public List<Reply> getQuestionPublicReplies(long var1, String var3) throws QuestionReplyException;

    public List<Reply> getQuestionPrivateReplies(long var1, String var3) throws QuestionReplyException;

    public List<Recipient> getQuestionRecipients(long var1) throws QuestionReplyException;

    public Reply getReply(long var1) throws QuestionReplyException;

    public List<Question> getSendQuestions(String var1, String var2) throws QuestionReplyException;

    public List<Question> getReceiveQuestions(String var1, String var2) throws QuestionReplyException;

    public List<Question> getQuestions(String var1) throws QuestionReplyException;

    public List<Question> getAllQuestions(String var1) throws QuestionReplyException;

    public List<Question> getAllQuestionsByCategory(String var1, String var2) throws QuestionReplyException;

    public List<Question> getPublicQuestions(String var1) throws QuestionReplyException;

    public long createQuestionReply(Question var1, Reply var2) throws QuestionReplyException;
}

