/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.chat;

import java.util.List;
import javax.inject.Inject;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.chat.servers.ChatServer;
import org.silverpeas.core.chat.servers.DefaultChatServer;
import org.silverpeas.core.socialnetwork.relationship.RelationShipService;
import org.silverpeas.kernel.logging.SilverLogger;

@Service
public class ChatUsersRegistration {
    @Inject
    @DefaultChatServer
    private ChatServer chatServer;
    @Inject
    private RelationShipService relationShipService;
    private final SilverLogger logger = SilverLogger.getLogger((Object)this);

    public boolean isChatServiceEnabled() {
        return ChatServer.isEnabled();
    }

    public boolean isAlreadyRegistered(User user) {
        return this.chatServer.isUserExisting(user);
    }

    public void registerUser(User user) {
        if (!this.isChatServiceAllowed(user)) {
            this.logger.debug("The user {0} isn't allowed to access the chat service", new Object[]{user.getDisplayedName()});
        } else if (this.isAlreadyRegistered(user)) {
            this.logger.debug("The user {0} is already registered to access the chat service", new Object[]{user.getDisplayedName()});
        } else {
            this.logger.debug("Register user {0}", new Object[]{user.getDisplayedName()});
            this.chatServer.createUser(user);
            List contactIds = this.relationShipService.getMyContactsIds(Integer.parseInt(user.getId()));
            contactIds.stream().map(User::getById).filter(this::isChatServiceAllowed).forEach(c -> {
                this.registerUser((User)c);
                this.logger.debug("Register relationship {0} - {1}", new Object[]{user.getDisplayedName(), c.getDisplayedName()});
                this.chatServer.createRelationShip(user, (User)c);
            });
        }
    }

    public void unregisterUser(User user) {
        if (this.isChatServiceEnabled() && this.isAlreadyRegistered(user)) {
            this.logger.debug("Unregister user {0}", new Object[]{user.getDisplayedName()});
            this.chatServer.deleteUser(user);
        }
    }

    private boolean isChatServiceAllowed(User user) {
        return this.chatServer.isAllowed(user);
    }
}

