/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.silverstatistics.volume.service;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import org.apache.commons.io.filefilter.AndFileFilter;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.NameFileFilter;
import org.silverpeas.core.admin.service.OrganizationController;
import org.silverpeas.core.silverstatistics.volume.model.DirectoryStats;
import org.silverpeas.core.silverstatistics.volume.service.DirectorySizeComputer;
import org.silverpeas.core.silverstatistics.volume.service.FileNumberComputer;
import org.silverpeas.core.util.file.FileRepositoryManager;
import org.silverpeas.kernel.util.StringUtil;

public class DirectoryVolumeService {
    private final File workspace;
    private boolean onlyComponentData;

    public DirectoryVolumeService() {
        this(new File(FileRepositoryManager.getUploadPath()));
        this.onlyComponentData = true;
    }

    DirectoryVolumeService(File workspace) {
        this.workspace = workspace;
        this.onlyComponentData = false;
    }

    private List<DirectorySizeComputer> buildSizeScanners(File dataDirectory, String userId) {
        File[] files = this.listDirectoriesToScan(dataDirectory, userId);
        ArrayList<DirectorySizeComputer> result = new ArrayList<DirectorySizeComputer>(files.length);
        for (File componentDir : files) {
            result.add(new DirectorySizeComputer(componentDir, this.onlyComponentData));
        }
        return result;
    }

    private List<FileNumberComputer> buildFileNumberScanners(File dataDirectory, String userId) {
        File[] files = this.listDirectoriesToScan(dataDirectory, userId);
        ArrayList<FileNumberComputer> result = new ArrayList<FileNumberComputer>(files.length);
        for (File componentDir : files) {
            result.add(new FileNumberComputer(componentDir, this.onlyComponentData));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long getTotalSize() throws InterruptedException, ExecutionException {
        List<DirectorySizeComputer> scanners = this.buildSizeScanners(this.workspace, null);
        long totalSize = 0L;
        ExecutorService executor = Executors.newFixedThreadPool(this.getNumberOfThread());
        List result = executor.invokeAll(scanners);
        try {
            for (Future future : result) {
                DirectoryStats stats = (DirectoryStats)future.get();
                totalSize += stats.getDirectorySize();
            }
        }
        finally {
            executor.shutdown();
        }
        return totalSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String[]> getSizeVentilation(String userId) throws InterruptedException, ExecutionException {
        List<DirectorySizeComputer> scanners = this.buildSizeScanners(this.workspace, userId);
        HashMap<String, String[]> volume = new HashMap<String, String[]>(scanners.size());
        ExecutorService executor = Executors.newFixedThreadPool(this.getNumberOfThread());
        List result = executor.invokeAll(scanners);
        try {
            for (Future future : result) {
                DirectoryStats stats = (DirectoryStats)future.get();
                volume.put(stats.getDirectoryName(), new String[]{String.valueOf(stats.getDirectorySize()), null, null});
            }
        }
        finally {
            executor.shutdown();
        }
        return volume;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String[]> getFileNumberVentilation(String userId) throws InterruptedException, ExecutionException {
        List<FileNumberComputer> scanners = this.buildFileNumberScanners(this.workspace, userId);
        HashMap<String, String[]> volume = new HashMap<String, String[]>(scanners.size());
        ExecutorService executor = Executors.newFixedThreadPool(this.getNumberOfThread());
        List result = executor.invokeAll(scanners);
        try {
            for (Future future : result) {
                DirectoryStats stats = (DirectoryStats)future.get();
                volume.put(stats.getDirectoryName(), new String[]{String.valueOf(stats.getNumberOfFiles()), null, null});
            }
        }
        finally {
            executor.shutdown();
        }
        return volume;
    }

    private File[] listDirectoriesToScan(File dataDirectory, String userId) {
        IOFileFilter filter;
        OrganizationController controller = OrganizationController.get();
        if (!StringUtil.isDefined((String)userId) || controller.getUserDetail(userId).isAccessAdmin()) {
            filter = DirectoryFileFilter.DIRECTORY;
        } else {
            String[] spaceIds = controller.getAllSpaceIds(userId);
            List componentIds = Arrays.stream(spaceIds).flatMap(i -> Arrays.stream(controller.getAllComponentIdsRecur(i))).collect(Collectors.toList());
            filter = new AndFileFilter(DirectoryFileFilter.DIRECTORY, (IOFileFilter)new NameFileFilter(componentIds));
        }
        return dataDirectory.listFiles((FileFilter)filter);
    }

    private int getNumberOfThread() {
        return Runtime.getRuntime().availableProcessors();
    }
}

