/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.silverstatistics.volume.service;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Optional;
import java.util.concurrent.Callable;
import org.silverpeas.core.admin.component.model.SilverpeasComponent;
import org.silverpeas.core.silverstatistics.volume.model.DirectoryStats;
import org.silverpeas.core.silverstatistics.volume.service.ComponentStatisticsProvider;
import org.silverpeas.kernel.logging.SilverLogger;

abstract class AbstractComputer
implements Callable<DirectoryStats> {
    protected final File directory;
    private final boolean onlyComponentData;

    AbstractComputer(File directory, boolean onlyComponentData) {
        this.directory = directory;
        this.onlyComponentData = onlyComponentData;
    }

    @Override
    public final DirectoryStats call() {
        DirectoryStats result = new DirectoryStats(this.directory.getName());
        Optional component = SilverpeasComponent.getByInstanceId((String)this.directory.getName());
        if (this.onlyComponentData && !component.isPresent()) {
            return result;
        }
        FileVisitorOfTransverseServices<AbstractComputer> fileVisitor = new FileVisitorOfTransverseServices<AbstractComputer>(this, this.onlyComponentData);
        try {
            Files.walkFileTree(Paths.get(this.directory.getPath(), new String[0]), fileVisitor);
        }
        catch (IOException e) {
            SilverLogger.getLogger((Object)this).error((Throwable)e);
        }
        this.setTransverseResult(result);
        component.ifPresent(c -> ComponentStatisticsProvider.getByComponentName(c.getName()).ifPresent(s -> this.setSpecificResult(result, (ComponentStatisticsProvider)s)));
        return result;
    }

    protected abstract void handleTransverseFile(Path var1, BasicFileAttributes var2);

    protected abstract void setTransverseResult(DirectoryStats var1);

    protected abstract void setSpecificResult(DirectoryStats var1, ComponentStatisticsProvider var2);

    private static class FileVisitorOfTransverseServices<C extends AbstractComputer>
    implements FileVisitor<Path> {
        private final C computer;
        private final boolean onlyComponentData;
        private boolean canVisitFile;

        private FileVisitorOfTransverseServices(C computer, boolean onlyComponentData) {
            this.computer = computer;
            this.onlyComponentData = onlyComponentData;
            this.canVisitFile = !onlyComponentData;
        }

        @Override
        public final FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
            if (this.onlyComponentData && this.isAttachmentRepository(dir)) {
                this.canVisitFile = true;
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public final FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
            if (this.canVisitFile && !this.isWysiwygContent(file)) {
                ((AbstractComputer)this.computer).handleTransverseFile(file, attrs);
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public final FileVisitResult visitFileFailed(Path file, IOException exc) {
            SilverLogger.getLogger((Object)this).warn((Throwable)exc);
            return FileVisitResult.CONTINUE;
        }

        @Override
        public final FileVisitResult postVisitDirectory(Path dir, IOException exc) {
            if (this.onlyComponentData && this.isAttachmentRepository(dir)) {
                this.canVisitFile = false;
            }
            return FileVisitResult.CONTINUE;
        }

        private boolean isAttachmentRepository(Path dir) {
            return dir.getFileName().toString().startsWith("simpledoc_");
        }

        private boolean isWysiwygContent(Path file) {
            return file.getFileName().toString().matches(".+wysiwyg_[a-z]+[.]txt");
        }
    }
}

