/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.kernel.util;

import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import org.silverpeas.kernel.util.ServiceLoader;
import org.silverpeas.kernel.util.StringUtil;

public interface SystemWrapper {
    public static SystemWrapper getInstance() {
        return ServiceLoader.get(SystemWrapper.class);
    }

    default public String getenv(String name) {
        return System.getenv(name);
    }

    default public Map<String, String> getenv() {
        return System.getenv();
    }

    default public Properties getProperties() {
        return System.getProperties();
    }

    default public void setProperties(Properties props) {
        Enumeration<?> propertyNames = props.propertyNames();
        while (propertyNames.hasMoreElements()) {
            String key = (String)propertyNames.nextElement();
            this.setProperty(key, props.getProperty(key));
        }
    }

    default public String setProperty(String key, String value) {
        String previousValue = null;
        if (StringUtil.isDefined(value)) {
            previousValue = System.setProperty(key, value);
        }
        return previousValue;
    }

    default public String getProperty(String key) {
        return System.getProperty(key);
    }

    default public String getProperty(String key, String def) {
        return System.getProperty(key, def);
    }
}

