/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.kernel.util;

import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.text.Normalizer;
import java.util.Arrays;
import java.util.Base64;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.silverpeas.kernel.SilverpeasException;

public class StringUtil {
    public static final String EMPTY = "";
    public static final String NEWLINE = System.lineSeparator();
    private static final String PATTERN_START = "{";
    private static final String PATTERN_END = "}";
    private static final String TRUNCATED_TEXT_SUFFIX = "...";
    private static final String HOUR_PATTERN = "^([0-1]?\\d|2[0-4]):([0-5]\\d)(:[0-5]\\d)?$";

    public static String emptyString() {
        return EMPTY;
    }

    public static boolean startsWithIgnoreCase(String str, String prefix) {
        return StringUtils.startsWithIgnoreCase((CharSequence)str, (CharSequence)prefix);
    }

    public static String abbreviate(String str, int offset, int maxWidth) {
        return StringUtils.abbreviate((String)str, (int)offset, (int)maxWidth);
    }

    public static String abbreviate(String str, int maxWidth) {
        return StringUtils.abbreviate((String)str, (int)maxWidth);
    }

    public static String leftPad(String str, int size, String padStr) {
        return StringUtils.leftPad((String)str, (int)size, (String)padStr);
    }

    public static <T extends CharSequence> T defaultIfBlank(T str, T defaultStr) {
        return (T)StringUtils.defaultIfBlank(str, defaultStr);
    }

    public static boolean isDefined(String str) {
        return str != null && !str.trim().isEmpty() && !"null".equalsIgnoreCase(str);
    }

    public static boolean isNotDefined(String str) {
        return !StringUtil.isDefined(str);
    }

    public static void requireDefined(String str) {
        if (StringUtil.isNotDefined(str)) {
            throw new AssertionError((Object)(str + " isn't defined!"));
        }
    }

    public static void requireDefined(String str, String message) {
        if (StringUtil.isNotDefined(str)) {
            throw new AssertionError((Object)message);
        }
    }

    public static <T extends SilverpeasException> void requireDefined(String str, Supplier<T> exceptionSupplier) throws T {
        if (StringUtil.isNotDefined(str)) {
            throw (SilverpeasException)exceptionSupplier.get();
        }
    }

    public static boolean startsWith(CharSequence str, CharSequence prefix) {
        return StringUtils.startsWith((CharSequence)str, (CharSequence)prefix);
    }

    public static String[] splitByWholeSeparator(String str, String separator) {
        return StringUtils.splitByWholeSeparator((String)str, (String)separator);
    }

    public static String[] split(String str, char separatorChar) {
        return StringUtils.split((String)str, (char)separatorChar);
    }

    public static String[] split(String str, String separatorChars) {
        return StringUtils.split((String)str, (String)separatorChars);
    }

    public static String capitalize(String str) {
        return StringUtils.capitalize((String)str);
    }

    public static String uncapitalize(String str) {
        return StringUtils.uncapitalize((String)str);
    }

    public static String normalize(String string) {
        String normalized = string;
        if (normalized != null) {
            normalized = Normalizer.normalize(normalized, Normalizer.Form.NFC);
        }
        return normalized;
    }

    public static String normalizeByRemovingAccent(String string) {
        String normalized = string;
        if (normalized != null) {
            normalized = Normalizer.normalize(normalized, Normalizer.Form.NFD);
            normalized = normalized.replaceAll("\\p{InCombiningDiacriticalMarks}+", EMPTY);
        }
        return normalized;
    }

    public static String defaultStringIfNotDefined(String string) {
        return StringUtil.defaultStringIfNotDefined(string, EMPTY);
    }

    public static String defaultStringIfNotDefined(String string, String defaultString) {
        return Objects.toString(StringUtil.isDefined(string) ? string : null, defaultString);
    }

    public static Optional<String> definedString(String string) {
        return Optional.ofNullable(string).filter(StringUtil::isDefined);
    }

    public static boolean isInteger(String value) {
        try {
            Integer.parseInt(value);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static int asInt(String value, int defaultValue) {
        int integer;
        try {
            integer = value == null ? defaultValue : Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            integer = defaultValue;
        }
        return integer;
    }

    public static boolean isLong(String value) {
        try {
            Long.parseLong(value);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static float asFloat(String value) {
        String charge;
        if (StringUtil.isFloat(value)) {
            return Float.parseFloat(value);
        }
        if (value != null && StringUtil.isFloat(charge = value.replace(',', '.'))) {
            return Float.parseFloat(charge);
        }
        return 0.0f;
    }

    public static boolean isFloat(String value) {
        try {
            Float.parseFloat(value);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static String escapeQuote(String text) {
        return text.replace("'", " ");
    }

    public static String toAcceptableFilename(String name) {
        String fileName = name;
        fileName = fileName.replace('\\', '_');
        fileName = fileName.replace('/', '_');
        fileName = fileName.replace('$', '_');
        fileName = fileName.replace('%', '_');
        fileName = fileName.replace('?', '_');
        fileName = fileName.replace(':', '_');
        fileName = fileName.replace('*', '_');
        fileName = fileName.replace('\"', '_');
        fileName = fileName.replace('<', '_');
        fileName = fileName.replace('>', '_');
        fileName = fileName.replace('|', '_');
        return fileName;
    }

    public static String format(String label, Map<String, ?> values) {
        StringBuilder sb = new StringBuilder();
        int startIndex = label.indexOf(PATTERN_START);
        while (startIndex != -1) {
            int endIndex = label.indexOf(PATTERN_END, startIndex);
            if (endIndex != -1) {
                String patternKey = label.substring(startIndex + 1, endIndex);
                if (values.containsKey(patternKey)) {
                    Object value = values.get(patternKey);
                    sb.append(label, 0, startIndex).append(value != null ? value.toString() : EMPTY);
                } else {
                    sb.append(label, 0, endIndex + 1);
                }
                label = label.substring(endIndex + 1);
                startIndex = label.indexOf(PATTERN_START);
                continue;
            }
            sb.append(label);
            label = EMPTY;
            startIndex = -1;
        }
        sb.append(label);
        return sb.toString();
    }

    public static String truncate(String text, int maxLength) {
        if (text == null || text.length() <= maxLength) {
            return text;
        }
        if (maxLength <= 3) {
            return TRUNCATED_TEXT_SUFFIX;
        }
        return text.substring(0, maxLength - 3) + TRUNCATED_TEXT_SUFFIX;
    }

    public static String regexReplace(String source, String regex, String replacement) {
        if (StringUtil.isNotDefined(source) || StringUtil.isNotDefined(regex)) {
            return source;
        }
        return source.replaceAll(regex, replacement);
    }

    public static boolean isValidHour(String time) {
        return StringUtil.isDefined(time) && Pattern.matches(HOUR_PATTERN, time);
    }

    public static String convertToEncoding(String toConvert, String encoding) {
        try {
            return new String(toConvert.getBytes(Charset.defaultCharset()), encoding);
        }
        catch (UnsupportedEncodingException ex) {
            return toConvert;
        }
    }

    public static boolean getBooleanValue(String expression) {
        return "true".equalsIgnoreCase(expression) || "yes".equalsIgnoreCase(expression) || "y".equalsIgnoreCase(expression) || "oui".equalsIgnoreCase(expression) || "1".equalsIgnoreCase(expression);
    }

    public static boolean areStringEquals(String s1, String s2) {
        if (s1 == null) {
            return s2 == null;
        }
        return s1.equals(s2);
    }

    public static String asBase64(byte[] binaryData) {
        return Base64.getEncoder().encodeToString(binaryData);
    }

    public static byte[] fromBase64(String base64Text) {
        return Base64.getDecoder().decode(base64Text);
    }

    public static Iterable<String> splitString(String str, char separatorChar) {
        return Arrays.asList(StringUtils.split((String)str, (char)separatorChar));
    }

    public static String doubleAntiSlash(String path) {
        StringBuilder res = new StringBuilder(path);
        int k = 0;
        int i = 0;
        int j = 1;
        while (i < path.length()) {
            if (path.charAt(i) == '\\') {
                boolean hasNotAntiSlashBefore;
                boolean hasNotAntiSlashAfter = j < path.length() && path.charAt(j) != '\\';
                boolean bl = hasNotAntiSlashBefore = i > 0 && path.charAt(i - 1) != '\\';
                if (hasNotAntiSlashAfter && hasNotAntiSlashBefore) {
                    res.insert(k + i, '\\');
                    ++k;
                }
            }
            ++i;
            ++j;
        }
        return res.toString();
    }

    public static boolean likeIgnoreCase(String actualValue, String expectedValue) {
        return new Like(actualValue, expectedValue, true).test();
    }

    public static boolean like(String actualValue, String expectedValue) {
        return new Like(actualValue, expectedValue, false).test();
    }

    private StringUtil() {
    }

    private static class Like {
        private final String actual;
        private final String expected;

        private Like(String actual, String expected, boolean ignoreCase) {
            if (ignoreCase) {
                this.actual = StringUtil.defaultStringIfNotDefined(actual).toLowerCase();
                this.expected = StringUtil.defaultStringIfNotDefined(expected).toLowerCase();
            } else {
                this.actual = StringUtil.defaultStringIfNotDefined(actual);
                this.expected = StringUtil.defaultStringIfNotDefined(expected);
            }
        }

        boolean test() {
            ScanContext ctx = new ScanContext();
            block5: while (ctx.canConsumeAnotherToken()) {
                char current = ctx.currentToken();
                switch (current) {
                    case '\\': {
                        this.processEscapeCard(ctx, current);
                        continue block5;
                    }
                    case '_': {
                        ctx.next();
                        ctx.matches = ctx.actualIdx <= this.actual.length();
                        continue block5;
                    }
                    case '%': {
                        this.processWildcardAny(ctx);
                        continue block5;
                    }
                }
                ctx.matches = ctx.actualMatches(current);
                ctx.next();
            }
            return ctx.matches && ctx.isActualFullyChecked();
        }

        private void processEscapeCard(ScanContext ctx, char current) {
            boolean escape;
            char next = ctx.nextToken();
            boolean bl = escape = next == '%' || next == '_';
            if (escape) {
                ctx.matches = this.actual.charAt(ctx.actualIdx) == next;
                ++ctx.expectedIdx;
            } else {
                ctx.matches = this.actual.charAt(ctx.actualIdx) == current;
            }
            ++ctx.actualIdx;
        }

        private void processWildcardAny(ScanContext ctx) {
            if (!this.goToNextNonWildcardToken(ctx)) {
                return;
            }
            int underscoreCount = 0;
            while (ctx.hasSomeToken() && ctx.currentToken() == '_') {
                ++underscoreCount;
                ++ctx.expectedIdx;
            }
            if (!ctx.hasSomeToken()) {
                if (underscoreCount > 0) {
                    ctx.matches = this.actual.length() - ctx.actualIdx >= underscoreCount;
                }
                ctx.actualIdx = this.actual.length();
                return;
            }
            StringBuilder exp = new StringBuilder();
            this.subtractExpectedTextToNextWildcard(ctx, exp);
            if (underscoreCount > 0) {
                if (exp.length() > 0) {
                    ctx.actualIdx = this.actual.indexOf(exp.toString(), ctx.actualIdx + underscoreCount) + exp.length();
                    ctx.matches = ctx.actualIdx >= exp.length();
                } else {
                    ctx.actualIdx += underscoreCount;
                    ctx.matches = ctx.actualIdx <= this.actual.length();
                }
            } else {
                ctx.actualIdx = this.actual.indexOf(exp.toString(), ctx.actualIdx) + exp.length();
                ctx.matches = ctx.actualIdx >= exp.length();
            }
        }

        private boolean goToNextNonWildcardToken(ScanContext ctx) {
            do {
                ++ctx.expectedIdx;
            } while (ctx.hasSomeToken() && ctx.currentToken() == '%');
            if (!ctx.hasSomeToken()) {
                ctx.actualIdx = this.actual.length();
                return false;
            }
            return true;
        }

        private void subtractExpectedTextToNextWildcard(ScanContext ctx, StringBuilder expression) {
            char endChar = ctx.currentToken();
            while (ctx.hasSomeToken() && endChar != '_' && endChar != '%') {
                if (endChar == '\\' && ++ctx.expectedIdx < this.expected.length()) {
                    char nextChar = ctx.currentToken();
                    if (nextChar == '_' || nextChar == '%') {
                        expression.append(nextChar);
                        endChar = ctx.safeNextToken();
                        continue;
                    }
                    if (nextChar != '\\') {
                        expression.append(endChar).append(nextChar);
                        endChar = ctx.safeNextToken();
                        continue;
                    }
                    expression.append(endChar);
                    endChar = nextChar;
                    continue;
                }
                expression.append(endChar);
                endChar = ctx.safeNextToken();
            }
        }

        private class ScanContext {
            protected int actualIdx = 0;
            protected int expectedIdx = 0;
            protected boolean matches = true;

            private ScanContext() {
            }

            public boolean canConsumeAnotherToken() {
                return this.hasSomeToken() && this.matches;
            }

            public boolean hasSomeToken() {
                return this.expectedIdx < Like.this.expected.length();
            }

            public boolean actualMatches(char token) {
                return this.actualIdx < Like.this.actual.length() && Like.this.actual.charAt(this.actualIdx) == token;
            }

            public boolean isActualFullyChecked() {
                return this.actualIdx == Like.this.actual.length();
            }

            public char currentToken() {
                return Like.this.expected.charAt(this.expectedIdx);
            }

            public char nextToken() {
                return Like.this.expected.charAt(++this.expectedIdx);
            }

            public char safeNextToken() {
                ++this.expectedIdx;
                return this.hasSomeToken() ? this.currentToken() : (char)'\u0000';
            }

            public void next() {
                ++this.expectedIdx;
                ++this.actualIdx;
            }
        }
    }
}

