/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.webapi.selection;

import java.io.Serializable;
import java.time.temporal.Temporal;
import java.util.Date;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import org.silverpeas.core.date.Period;
import org.silverpeas.core.date.TemporalConverter;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class PeriodOfTime
implements Serializable {
    private Date startDate;
    private Date endDate;
    private boolean isInDays;

    private PeriodOfTime() {
    }

    public static PeriodOfTime from(Period period) {
        PeriodOfTime periodOfTime = new PeriodOfTime();
        periodOfTime.isInDays = period.isInDays();
        periodOfTime.startDate = Date.from(TemporalConverter.asInstant((Temporal)period.getStartDate()));
        periodOfTime.endDate = Date.from(TemporalConverter.asInstant((Temporal)period.getEndDate()));
        return periodOfTime;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public boolean isInDays() {
        return this.isInDays;
    }
}

