/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.webapi.notification.sse;

import java.io.IOException;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.servlet.AsyncContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.admin.user.model.UserDetail;
import org.silverpeas.core.notification.sse.SilverpeasAsyncContext;
import org.silverpeas.core.notification.sse.SilverpeasServerEventContext;
import org.silverpeas.core.notification.sse.SseLogger;
import org.silverpeas.core.notification.user.client.NotificationManagerSettings;
import org.silverpeas.core.security.session.SessionInfo;
import org.silverpeas.core.security.session.SessionManagementProvider;
import org.silverpeas.core.web.http.HttpRequest;
import org.silverpeas.core.web.mvc.controller.MainSessionController;
import org.silverpeas.core.web.mvc.webcomponent.SilverpeasAuthenticatedHttpServlet;
import org.silverpeas.core.webapi.notification.sse.SilverpeasServerEventWebAccess;
import org.silverpeas.kernel.logging.SilverLogger;
import org.silverpeas.kernel.util.StringUtil;

public abstract class SilverpeasServerSentEventServlet
extends SilverpeasAuthenticatedHttpServlet
implements SilverpeasServerEventWebAccess {
    private static final long serialVersionUID = -4766652077117461779L;
    private static final Set<String> sseUri = Collections.synchronizedSet(new LinkedHashSet());
    private static final String LAST_EVENT_ID_HEADER = "Last-Event-ID";
    private static final String HEARTBEAT_PARAM = "heartbeat";
    private static final String LAST_EVENT_ID_PARAM = "lastEventId";

    public static boolean isSseRequest(HttpServletRequest request) {
        return sseUri.contains(request.getRequestURI());
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse response) {
        Long lastServerEventId;
        boolean heartbeat;
        String userSessionId;
        UserDetail sessionUser;
        String requestURI;
        SilverLogger silverLogger;
        HttpRequest request;
        block9: {
            request = HttpRequest.decorate((HttpServletRequest)req);
            sseUri.add(request.getRequestURI());
            silverLogger = SseLogger.get();
            requestURI = request.getRequestURI();
            MainSessionController mainSessionController = this.getMainSessionController((HttpServletRequest)request);
            String mainSessionId = mainSessionController.getSessionId();
            sessionUser = mainSessionController.getCurrentUserDetail();
            if (sessionUser.isAnonymous()) {
                userSessionId = mainSessionId;
            } else {
                SessionInfo sessionInfo = SessionManagementProvider.getSessionManagement().getSessionInfo(mainSessionController.getSessionId());
                userSessionId = sessionInfo.getSessionId();
            }
            if (!"text/event-stream".equals(request.getHeader("Accept"))) {
                String errorMessage = "Server Sent Servlet accepts only 'test/event-stream' requests ({0})";
                silverLogger.error("Server Sent Servlet accepts only 'test/event-stream' requests ({0})", new Object[]{requestURI});
                this.throwHttpForbiddenError("Server Sent Servlet accepts only 'test/event-stream' requests ({0})");
            }
            silverLogger.debug("Asking for SSE communication (sessionUser={0}) on URI {1} (SessionId={2})", new Object[]{sessionUser.getId(), requestURI, userSessionId});
            response.setContentType("text/event-stream");
            response.setHeader("Cache-Control", "no-cache");
            response.setHeader("Connection", "keep-alive");
            response.setHeader("X-Accel-Buffering", "no");
            response.setCharacterEncoding("UTF-8");
            heartbeat = StringUtil.getBooleanValue((String)request.getParameter(HEARTBEAT_PARAM));
            try {
                lastServerEventId = Long.valueOf(request.getHeader(LAST_EVENT_ID_HEADER));
            }
            catch (NumberFormatException ignore) {
                lastServerEventId = request.getParameterAsLong(LAST_EVENT_ID_PARAM);
                if (lastServerEventId == null) break block9;
                heartbeat = true;
            }
        }
        try {
            if (!request.isAsyncStarted()) {
                SilverpeasServerEventWebAccess.WebAccessContext wac = new SilverpeasServerEventWebAccess.WebAccessContext(requestURI, request.getSession(false).getId(), userSessionId, (User)sessionUser);
                this.prepareEventsOnOpening(wac, lastServerEventId);
                AsyncContext startedAsyncContext = request.startAsync();
                SilverpeasAsyncContext asyncContext = SilverpeasAsyncContext.wrap((SilverLogger)silverLogger, (AsyncContext)startedAsyncContext, (String)userSessionId, (User)sessionUser);
                int userSessionTimeout = request.getSession(false).getMaxInactiveInterval() * 1000;
                int asyncTimeout = Math.min(NotificationManagerSettings.getSseAsyncTimeout(), userSessionTimeout);
                asyncContext.setTimeout((long)asyncTimeout);
                asyncContext.setLastServerEventId(lastServerEventId);
                asyncContext.setHeartbeat(heartbeat);
                this.send(wac, (SilverpeasServerEventContext)asyncContext);
            } else {
                silverLogger.warn("Strange that the asynchronous context is already started {0}", new Object[]{request.getAsyncContext()});
                response.setStatus(409);
            }
        }
        catch (IOException | IllegalStateException | ServletException e) {
            SilverLogger.getLogger((Object)this).error(e);
            response.setStatus(500);
        }
    }
}

