/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.webapi.notification.sse;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.Optional;
import javax.websocket.OnClose;
import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.Session;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.notification.sse.ServerEventDispatcherTask;
import org.silverpeas.core.notification.sse.SilverpeasServerEventContext;
import org.silverpeas.core.notification.sse.SilverpeasWebSocketContext;
import org.silverpeas.core.notification.sse.SseLogger;
import org.silverpeas.core.notification.user.client.NotificationManagerSettings;
import org.silverpeas.core.security.session.SessionInfo;
import org.silverpeas.core.security.session.SessionManagement;
import org.silverpeas.core.security.session.SessionManagementProvider;
import org.silverpeas.core.web.token.SilverpeasWebTokenService;
import org.silverpeas.core.webapi.notification.sse.SilverpeasServerEventWebAccess;
import org.silverpeas.kernel.logging.SilverLogger;
import org.silverpeas.kernel.util.StringUtil;

public abstract class SilverpeasServerEventWebSocket
implements SilverpeasServerEventWebAccess {
    private static final String LAST_EVENT_ID_PARAM = "Last-Event-ID";

    protected abstract String getTokenParameterName();

    protected SessionInfo getSessionInfo(Session wsSession) {
        return Optional.ofNullable((String)wsSession.getPathParameters().get(this.getTokenParameterName())).flatMap(arg_0 -> ((SilverpeasWebTokenService)SilverpeasWebTokenService.get()).consumeIdentifierBy(arg_0)).map(arg_0 -> ((SessionManagement)SessionManagementProvider.getSessionManagement()).getSessionInfo(arg_0)).orElse(SessionInfo.NoneSession);
    }

    @OnOpen
    public void onOpen(Session wsSession) throws IOException {
        SilverLogger silverLogger = SseLogger.get();
        String requestURI = wsSession.getRequestURI().toString();
        String wsSessionId = wsSession.getId();
        SessionInfo spSessionInfo = this.getSessionInfo(wsSession);
        if (!spSessionInfo.isDefined() || spSessionInfo.isAnonymous()) {
            silverLogger.debug("Asking for SSE websocket communication from an unhandled session (sessionId={0}) on URI {1}", new Object[]{wsSessionId, requestURI});
            wsSession.close();
            return;
        }
        wsSession.getAsyncRemote().setSendTimeout((long)NotificationManagerSettings.getWebSocketSendTimeout());
        User sessionUser = spSessionInfo.getUser();
        String userSessionId = spSessionInfo.getSessionId();
        silverLogger.debug("Asking for SSE websocket communication (sessionUser={0}) on URI {1} (SessionId={2})", new Object[]{sessionUser.getId(), requestURI, userSessionId});
        Long lastServerEventId = wsSession.getRequestParameterMap().getOrDefault(LAST_EVENT_ID_PARAM, Collections.emptyList()).stream().filter(StringUtil::isLong).map(Long::parseLong).findFirst().orElse(null);
        SilverpeasServerEventWebAccess.WebAccessContext wac = new SilverpeasServerEventWebAccess.WebAccessContext(requestURI, wsSessionId, userSessionId, sessionUser);
        this.prepareEventsOnOpening(wac, lastServerEventId);
        SilverpeasWebSocketContext websocketContext = SilverpeasWebSocketContext.wrap((Session)wsSession, (String)userSessionId, (User)sessionUser);
        try {
            this.send(wac, (SilverpeasServerEventContext)websocketContext);
            silverLogger.debug("{0} SSE websockets currently opened (from session opening)", new Object[]{wsSession.getOpenSessions().size()});
        }
        catch (IOException | IllegalStateException e) {
            SilverLogger.getLogger((Object)this).error((Throwable)e);
        }
    }

    @OnClose
    public void onClose(Session wsSession) {
        SilverLogger silverLogger = SseLogger.get();
        ServerEventDispatcherTask.unregisterBySessionId((String)wsSession.getId());
        silverLogger.debug("{0} SSE websockets currently opened (from session closing)", new Object[]{wsSession.getOpenSessions().size() - 1});
    }

    @OnError
    public void onError(Session wsSession, Throwable throwable) {
        SseLogger.get().warn(MessageFormat.format("Error {1} with session {0} ", wsSession.getId(), throwable), new Object[0]);
    }

    @OnMessage
    public void onMessage(Session wsSession, String message) {
        SseLogger.get().warn(MessageFormat.format("Message {1} received with session {0} ", wsSession.getId(), message), new Object[0]);
    }
}

