/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.webapi.notification.sse;

import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.notification.sse.AbstractServerEvent;
import org.silverpeas.core.notification.sse.ServerEvent;
import org.silverpeas.core.notification.sse.behavior.IgnoreStoring;

class RetryServerEvent
extends AbstractServerEvent
implements IgnoreStoring {
    private static final ServerEvent.ServerEventName EVENT_NAME = () -> "RETRY_EVENT_SOURCE";
    private final String emitterSessionId;
    private final long lastServerEventId;

    private RetryServerEvent(String emitterSessionId, long lastServerEventId) {
        this.emitterSessionId = emitterSessionId;
        this.lastServerEventId = lastServerEventId;
        this.withData("Event source retry a new connection successfully.");
    }

    static RetryServerEvent createFor(String emitterSessionId, long lastServerEventId) {
        return new RetryServerEvent(emitterSessionId, lastServerEventId);
    }

    public long getId() {
        return this.lastServerEventId;
    }

    public ServerEvent.ServerEventName getName() {
        return EVENT_NAME;
    }

    public boolean isConcerned(String receiverSessionId, User receiver) {
        return this.emitterSessionId.equals(receiverSessionId);
    }
}

