/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.webapi.media.streaming;

import java.net.http.HttpResponse;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.silverpeas.core.media.streaming.StreamingProvider;
import org.silverpeas.core.media.streaming.StreamingProvidersRegistry;
import org.silverpeas.core.util.HttpUtil;
import org.silverpeas.kernel.logging.SilverLogger;

public class StreamingRequester {
    private StreamingRequester() {
    }

    protected static String getJsonOembedAsString(String homepageUrl) {
        return StreamingProvidersRegistry.get().getOembedUrl(homepageUrl).map(u -> u.replace("http:", "https:")).map(oembedUrl -> {
            try {
                HttpResponse<String> response = HttpUtil.httpClient().send(HttpUtil.toUrl((String)oembedUrl).header("Accept", "application/json").build(), HttpResponse.BodyHandlers.ofString());
                if (response.statusCode() != Response.Status.OK.getStatusCode()) {
                    throw new WebApplicationException(response.statusCode());
                }
                String jsonResponse = response.body();
                for (StreamingProvider provider : StreamingProvidersRegistry.get().getAll()) {
                    jsonResponse = jsonResponse.replaceAll("(?i)" + provider.getName(), provider.getName());
                }
                return jsonResponse;
            }
            catch (WebApplicationException wae) {
                SilverLogger.getLogger(StreamingRequester.class).error("{0} -> HTTP ERROR {1}", new Object[]{oembedUrl, wae.getMessage()});
                throw wae;
            }
            catch (Exception e) {
                SilverLogger.getLogger(StreamingRequester.class).error("{0} -> {1}", new Object[]{oembedUrl, e.getMessage()});
                if (e instanceof InterruptedException) {
                    Thread.currentThread().interrupt();
                }
                throw new WebApplicationException((Throwable)e);
            }
        }).orElse("");
    }
}

