/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.webapi.media.streaming;

import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import javax.annotation.PostConstruct;
import javax.inject.Singleton;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.media.streaming.StreamingProvider;
import org.silverpeas.core.util.ServiceProvider;
import org.silverpeas.core.webapi.media.streaming.OembedDataEntity;
import org.silverpeas.core.webapi.media.streaming.StreamingProviderDataEntity;
import org.silverpeas.core.webapi.media.streaming.VimeoDataEntity;
import org.silverpeas.core.webapi.media.streaming.YoutubeDataEntity;

@Service
@Singleton
public class StreamingProviderDataEntityFactory {
    private static final BiFunction<StreamingProvider, OembedDataEntity, StreamingProviderDataEntity> DEFAULT = StreamingProviderDataEntity::new;
    private final Map<String, BiFunction<StreamingProvider, OembedDataEntity, StreamingProviderDataEntity>> constructorRegistry = Collections.synchronizedMap(new HashMap());

    public static StreamingProviderDataEntityFactory get() {
        return (StreamingProviderDataEntityFactory)ServiceProvider.getService(StreamingProviderDataEntityFactory.class, (Annotation[])new Annotation[0]);
    }

    @PostConstruct
    protected void setupDefaults() {
        this.registerConstructor("youtube", YoutubeDataEntity::new);
        this.registerConstructor("vimeo", VimeoDataEntity::new);
    }

    public void registerConstructor(String providerName, BiFunction<StreamingProvider, OembedDataEntity, StreamingProviderDataEntity> constructor) {
        this.constructorRegistry.put(providerName, constructor);
    }

    StreamingProviderDataEntity createWith(StreamingProvider streamingProvider, OembedDataEntity oembedData) {
        return this.constructorRegistry.getOrDefault(streamingProvider.getName(), DEFAULT).apply(streamingProvider, oembedData);
    }
}

