/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.webapi.documenttemplate;

import java.net.URI;
import javax.validation.constraints.NotNull;
import org.silverpeas.core.documenttemplate.DocumentTemplate;
import org.silverpeas.core.viewer.service.PreviewService;
import org.silverpeas.core.web.rs.WebEntity;
import org.silverpeas.core.webapi.viewer.PreviewEntity;

public class DocumentTemplateEntity
implements WebEntity {
    private static final long serialVersionUID = 5543809634585798730L;
    private URI uri;
    @NotNull
    private String id;
    @NotNull
    private String name;
    @NotNull
    private String description;
    private PreviewEntity preview;

    public static DocumentTemplateEntity from(DocumentTemplate documentTemplate, URI uri, String language) {
        return new DocumentTemplateEntity(documentTemplate, uri, language);
    }

    protected DocumentTemplateEntity() {
    }

    public DocumentTemplateEntity(DocumentTemplate documentTemplate, URI uri, String language) {
        this.uri = uri;
        this.id = documentTemplate.getId();
        this.name = documentTemplate.getName(language);
        this.description = documentTemplate.getDescription(language);
        this.preview = PreviewEntity.createFrom(PreviewService.get().getPreview(documentTemplate.getViewerContext(language)));
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public PreviewEntity getPreview() {
        return this.preview;
    }

    public URI getURI() {
        return this.uri;
    }
}

