/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.webapi.contribution;

import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.silverpeas.core.webapi.contribution.FormFieldValueEntity;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class FormFieldEntity {
    @XmlElement(defaultValue="")
    private String type;
    @XmlElement(defaultValue="")
    private String name;
    @XmlElement(defaultValue="")
    private String label;
    @XmlElement(defaultValue="")
    private FormFieldValueEntity value;
    @XmlElement(defaultValue="")
    private List<FormFieldValueEntity> values;
    @XmlElement
    private boolean multiValues = false;

    private FormFieldEntity(String type, String name, String label, FormFieldValueEntity value) {
        this.type = type;
        this.name = name;
        this.label = label;
        this.value = value;
    }

    private FormFieldEntity(String type, String name, String label, List<FormFieldValueEntity> values) {
        this.type = type;
        this.name = name;
        this.label = label;
        if (values != null && !values.isEmpty()) {
            if (values.size() == 1) {
                this.value = values.get(0);
            } else {
                this.values = values;
                this.multiValues = true;
            }
        }
    }

    public static FormFieldEntity createFrom(String type, String name, String label, FormFieldValueEntity value) {
        return new FormFieldEntity(type, name, label, value);
    }

    public static FormFieldEntity createFrom(String type, String name, String label, List<FormFieldValueEntity> values) {
        return new FormFieldEntity(type, name, label, values);
    }

    protected String getType() {
        return this.type;
    }

    protected String getName() {
        return this.name;
    }

    protected String getLabel() {
        return this.label;
    }

    protected FormFieldValueEntity getValue() {
        return this.value;
    }

    protected List<FormFieldValueEntity> getValues() {
        return this.values;
    }

    protected boolean isMultiValues() {
        return this.multiValues;
    }
}

