/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.webapi.contribution;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.commons.io.FilenameUtils;
import org.silverpeas.core.contribution.attachment.AttachmentServiceProvider;
import org.silverpeas.core.contribution.attachment.model.SimpleDocument;
import org.silverpeas.core.contribution.attachment.model.SimpleDocumentPK;
import org.silverpeas.core.contribution.content.form.DataRecord;
import org.silverpeas.core.contribution.content.form.Field;
import org.silverpeas.core.contribution.content.form.FieldTemplate;
import org.silverpeas.core.contribution.content.form.FieldValue;
import org.silverpeas.core.contribution.content.form.FieldValuesTemplate;
import org.silverpeas.core.contribution.content.form.FormException;
import org.silverpeas.core.contribution.content.form.displayers.WysiwygFCKFieldDisplayer;
import org.silverpeas.core.contribution.content.form.field.UserField;
import org.silverpeas.core.contribution.content.form.record.Parameter;
import org.silverpeas.core.contribution.template.publication.PublicationTemplate;
import org.silverpeas.core.contribution.template.publication.PublicationTemplateException;
import org.silverpeas.core.contribution.template.publication.PublicationTemplateManager;
import org.silverpeas.core.util.URLUtil;
import org.silverpeas.core.web.rs.RESTWebService;
import org.silverpeas.core.webapi.contribution.FormFieldValueEntity;
import org.silverpeas.kernel.logging.SilverLogger;
import org.silverpeas.kernel.util.StringUtil;

public abstract class AbstractContributionResource
extends RESTWebService {
    public abstract String getContributionId();

    protected String getDefaultFormId() {
        String xmlFormName = this.getOrganisationController().getComponentParameterValue(this.getComponentId(), "XMLFormName");
        if (StringUtil.isDefined((String)xmlFormName)) {
            return xmlFormName.substring(xmlFormName.indexOf(47) + 1, xmlFormName.indexOf(46));
        }
        return null;
    }

    protected String getDefaultPublicationTemplateLanguage() {
        return this.getUserPreferences().getLanguage();
    }

    private String createExternalId(String formId) {
        return this.getComponentId() + ":" + FilenameUtils.getBaseName((String)formId);
    }

    protected List<FormFieldValueEntity> getFormFieldValues(FieldTemplate fieldTemplate, DataRecord data, String lang) throws FormException {
        ArrayList<FormFieldValueEntity> values;
        block3: {
            int maxOccurrences;
            block2: {
                maxOccurrences = fieldTemplate.getMaximumNumberOfOccurrences();
                values = new ArrayList<FormFieldValueEntity>();
                FieldValue empty = FieldValue.emptyFor((String)lang);
                FieldValuesTemplate valuesTemplate = fieldTemplate.getFieldValuesTemplate(lang);
                if (valuesTemplate.isEmpty()) break block2;
                Field field = data.getField(fieldTemplate.getFieldName());
                String fieldValue = field.getValue(lang);
                if (!StringUtil.isDefined((String)fieldValue)) break block3;
                List fieldValues = Parameter.decode((String)fieldValue);
                for (String value : fieldValues) {
                    FormFieldValueEntity valueEntity = FormFieldValueEntity.createFrom(value, valuesTemplate.get(value).orElse(empty).getLabel());
                    values.add(valueEntity);
                }
                break block3;
            }
            for (int occ = 0; occ < maxOccurrences; ++occ) {
                Field field = data.getField(fieldTemplate.getFieldName(), occ);
                if (field == null || field.isNull()) continue;
                FormFieldValueEntity value = this.getFormFieldValue(fieldTemplate, field, lang);
                values.add(value);
            }
        }
        return values;
    }

    protected FormFieldValueEntity getFormFieldValue(FieldTemplate fieldTemplate, DataRecord data, String lang) throws FormException {
        Field field = data.getField(fieldTemplate.getFieldName());
        return this.getFormFieldValue(fieldTemplate, field, lang);
    }

    private FormFieldValueEntity getFormFieldValue(FieldTemplate fieldTemplate, Field field, String lang) {
        FormFieldValueEntity entity = "file".equals(field.getTypeName()) ? this.createFileValueEntity(field, lang) : ("user".equals(field.getTypeName()) ? this.createUserValueEntity((UserField)field) : this.createTextValueEntity(fieldTemplate, field, lang));
        return entity;
    }

    private FormFieldValueEntity createTextValueEntity(FieldTemplate fieldTemplate, Field field, String lang) {
        String fieldValue = field.getValue(lang);
        FormFieldValueEntity entity = StringUtil.isDefined((String)fieldValue) ? (fieldValue.startsWith("xmlWysiwygField_") ? FormFieldValueEntity.createFrom(null, WysiwygFCKFieldDisplayer.getContentFromFile((String)this.getComponentId(), (String)this.getContributionId(), (String)fieldTemplate.getFieldName(), (String)lang)) : FormFieldValueEntity.createFrom(null, fieldValue)) : FormFieldValueEntity.createFrom(null, "");
        return entity;
    }

    private FormFieldValueEntity createUserValueEntity(UserField userField) {
        return FormFieldValueEntity.createFrom(userField.getUserId(), userField.getValue());
    }

    private FormFieldValueEntity createFileValueEntity(Field field, String lang) {
        String fieldValue = field.getValue(lang);
        String attachmentId = null;
        Object attachmentUrl = null;
        URI attachmentUri = null;
        if (StringUtil.isDefined((String)fieldValue)) {
            String serverApplicationURL = URLUtil.getServerURL((HttpServletRequest)this.getHttpServletRequest()) + URLUtil.getApplicationURL();
            if (fieldValue.startsWith("/")) {
                attachmentUrl = fieldValue;
                fieldValue = null;
            } else {
                SimpleDocument attachment = AttachmentServiceProvider.getAttachmentService().searchDocumentById(new SimpleDocumentPK(fieldValue, this.getComponentId()), lang);
                if (attachment != null) {
                    attachmentId = fieldValue;
                    fieldValue = attachment.getTitle();
                    attachmentUrl = serverApplicationURL + attachment.getAttachmentURL();
                    try {
                        attachmentUri = new URI(URLUtil.getServerURL((HttpServletRequest)this.getHttpServletRequest()) + URLUtil.getSimpleURL((int)4, (String)attachmentId));
                    }
                    catch (URISyntaxException e) {
                        SilverLogger.getLogger((Object)((Object)this)).warn((Throwable)e);
                    }
                }
            }
        }
        if (fieldValue == null) {
            fieldValue = "";
        }
        FormFieldValueEntity entity = FormFieldValueEntity.createFrom(attachmentId, fieldValue).withLink((String)attachmentUrl).withAttachmentURI(attachmentUri);
        return entity;
    }

    protected PublicationTemplate getPublicationTemplate(String formId) {
        try {
            return PublicationTemplateManager.getInstance().getPublicationTemplate(this.createExternalId(formId));
        }
        catch (PublicationTemplateException e) {
            throw new WebApplicationException((Throwable)e, Response.Status.NOT_FOUND);
        }
    }
}

