/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.webapi.attachment;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URLDecoder;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.commons.io.FileUtils;
import org.silverpeas.core.ResourceReference;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.annotation.WebService;
import org.silverpeas.core.contribution.ContributionOperationContextPropertyHandler;
import org.silverpeas.core.contribution.attachment.ActifyDocumentProcessor;
import org.silverpeas.core.contribution.attachment.AttachmentServiceProvider;
import org.silverpeas.core.contribution.attachment.WebdavServiceProvider;
import org.silverpeas.core.contribution.attachment.model.SimpleDocument;
import org.silverpeas.core.contribution.attachment.model.SimpleDocumentPK;
import org.silverpeas.core.contribution.attachment.model.UnlockContext;
import org.silverpeas.core.contribution.attachment.model.UnlockOption;
import org.silverpeas.core.i18n.I18NHelper;
import org.silverpeas.core.io.file.SilverpeasFile;
import org.silverpeas.core.io.file.SilverpeasFileProvider;
import org.silverpeas.core.jcr.webdav.WebDavTokenGenerator;
import org.silverpeas.core.util.Charsets;
import org.silverpeas.core.util.file.FileUtil;
import org.silverpeas.core.web.attachment.SimpleDocumentUploadData;
import org.silverpeas.core.web.http.FileResponse;
import org.silverpeas.core.web.mvc.webcomponent.WebMessager;
import org.silverpeas.core.web.rs.UserPrivilegeValidation;
import org.silverpeas.core.web.rs.annotation.Authorized;
import org.silverpeas.core.web.util.IFrameAjaxTransportUtil;
import org.silverpeas.core.webapi.attachment.AbstractSimpleDocumentResource;
import org.silverpeas.core.webapi.attachment.SimpleDocumentEntity;
import org.silverpeas.core.webapi.media.EmbedMediaPlayerDispatcher;
import org.silverpeas.kernel.util.StringUtil;

@WebService
@Path(value="documents/{componentId}/document/{id}")
@Authorized
public class SimpleDocumentResource
extends AbstractSimpleDocumentResource {
    private static final String DOCUMENT_PATH_NODE = "document";
    @PathParam(value="id")
    private String simpleDocumentId;

    public String getSimpleDocumentId() {
        return this.simpleDocumentId;
    }

    @GET
    @Path(value="{lang}")
    @Produces(value={"application/json"})
    public SimpleDocumentEntity getDocument(@PathParam(value="lang") String lang) {
        SimpleDocument attachment = this.getSimpleDocument(lang);
        URI attachmentUri = this.getUri().getRequestUriBuilder().path(DOCUMENT_PATH_NODE).path(attachment.getLanguage()).build(new Object[0]);
        return SimpleDocumentEntity.fromAttachment(attachment).withURI(attachmentUri);
    }

    @DELETE
    @Produces(value={"application/json"})
    public void deleteDocument() {
        ContributionOperationContextPropertyHandler.parseRequest((HttpServletRequest)this.getHttpRequest());
        SimpleDocument document = this.getSimpleDocument(null);
        document.setUpdatedBy(this.getUser().getId());
        AttachmentServiceProvider.getAttachmentService().deleteAttachment(document);
    }

    @DELETE
    @Path(value="content/{lang}")
    @Produces(value={"application/json"})
    public void deleteContent(@PathParam(value="lang") String lang) {
        ContributionOperationContextPropertyHandler.parseRequest((HttpServletRequest)this.getHttpRequest());
        SimpleDocument document = this.getSimpleDocument(lang);
        AttachmentServiceProvider.getAttachmentService().removeContent(document, lang, false);
    }

    @POST
    @Path(value="{filename}")
    @Consumes(value={"multipart/form-data"})
    public Response updateDocument(@PathParam(value="filename") String filename) throws IOException {
        SimpleDocumentUploadData uploadData = SimpleDocumentUploadData.decode(this.getHttpRequest());
        try {
            String normalizedFileName = StringUtil.normalize((String)URLDecoder.decode(filename, Charsets.UTF_8));
            SimpleDocumentEntity entity = this.updateSimpleDocument(uploadData, normalizedFileName);
            if ("IFrame".equals(uploadData.getXRequestedWith())) {
                return Response.ok().type(MediaType.TEXT_HTML_TYPE).entity((Object)IFrameAjaxTransportUtil.packObjectToJSonDataWithHtmlContainer(entity)).build();
            }
            return Response.ok().type(MediaType.APPLICATION_JSON_TYPE).entity((Object)entity).build();
        }
        catch (WebApplicationException wae) {
            WebApplicationException finalWae = wae;
            if ("IFrame".equals(uploadData.getXRequestedWith()) && wae.getResponse().getStatus() == Response.Status.PRECONDITION_FAILED.getStatusCode()) {
                finalWae = IFrameAjaxTransportUtil.createWebApplicationExceptionWithJSonErrorInHtmlContainer(wae);
            }
            throw finalWae;
        }
    }

    protected SimpleDocumentEntity updateSimpleDocument(SimpleDocumentUploadData uploadData, String filename) throws IOException {
        try {
            InputStream uploadedInputStream;
            ContributionOperationContextPropertyHandler.parseRequest((HttpServletRequest)this.getHttpRequest());
            SimpleDocument document = this.getSimpleDocument(uploadData.getLanguage());
            boolean isPublic = false;
            if (uploadData.getVersionType() != null) {
                isPublic = uploadData.getVersionType() == 0;
                document.setPublicDocument(isPublic);
            }
            document.setUpdatedBy(this.getUser().getId());
            document.setLanguage(uploadData.getLanguage());
            document.setTitle(uploadData.getTitle());
            document.setDescription(uploadData.getDescription());
            document.setComment(uploadData.getComment());
            String uploadedFilename = filename;
            if (StringUtil.isNotDefined((String)filename)) {
                uploadedFilename = uploadData.getRequestFile().getName();
            }
            boolean isWebdav = false;
            if (uploadData.getRequestFile() != null && (uploadedInputStream = uploadData.getRequestFile().getInputStream()) != null && StringUtil.isDefined((String)uploadedFilename) && !"no_file".equalsIgnoreCase(uploadedFilename)) {
                this.uploadFileAndUpdate(document, uploadedFilename, uploadedInputStream);
            } else {
                if (!FileUtils.getFile((String[])new String[]{document.getAttachmentPath()}).exists()) {
                    String errorMessage = this.getBundle().getString("attachment.dialog.error.file.mandatory");
                    WebMessager.getInstance().addError(errorMessage, new Object[0]);
                    throw new WebApplicationException(Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).entity((Object)errorMessage).build());
                }
                isWebdav = document.isOpenOfficeCompatible() && document.isEdited();
                this.updateWithAlreadyUploadedFile(document, isWebdav);
            }
            UnlockContext unlockContext = new UnlockContext(document.getId(), this.getUser().getId(), uploadData.getLanguage(), uploadData.getComment());
            this.unlockDocument(document, isPublic, isWebdav, unlockContext);
            document = this.getSimpleDocument(uploadData.getLanguage());
            URI attachmentUri = this.getUri().getRequestUriBuilder().path(DOCUMENT_PATH_NODE).path(document.getLanguage()).build(new Object[0]);
            return SimpleDocumentEntity.fromAttachment(document).withURI(attachmentUri);
        }
        catch (RuntimeException re) {
            this.performRuntimeException(re);
            throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    private void unlockDocument(SimpleDocument document, boolean isPublic, boolean isWebdav, UnlockContext unlockContext) {
        if (isWebdav) {
            unlockContext.addOption(UnlockOption.WEBDAV);
        } else {
            unlockContext.addOption(UnlockOption.UPLOAD);
        }
        if (!isPublic) {
            unlockContext.addOption(UnlockOption.PRIVATE_VERSION);
        }
        AttachmentServiceProvider.getAttachmentService().unlock(unlockContext);
        if (isWebdav) {
            WebDavTokenGenerator.getFor((User)this.getUser()).deleteToken(document.getId());
        }
    }

    private void updateWithAlreadyUploadedFile(SimpleDocument document, boolean isWebdav) {
        if (document.isVersioned()) {
            File content = new File(document.getAttachmentPath());
            AttachmentServiceProvider.getAttachmentService().lock(document.getId(), this.getUser().getId(), document.getLanguage());
            AttachmentServiceProvider.getAttachmentService().updateAttachment(document, content, true, true);
        } else {
            if (isWebdav) {
                WebdavServiceProvider.getWebdavService().updateDocumentContent(document);
            }
            AttachmentServiceProvider.getAttachmentService().updateAttachment(document, true, true);
        }
    }

    private void uploadFileAndUpdate(SimpleDocument document, String uploadedFilename, InputStream uploadedInputStream) throws IOException {
        File tempFile = File.createTempFile("silverpeas_", uploadedFilename);
        FileUtils.copyInputStreamToFile((InputStream)uploadedInputStream, (File)tempFile);
        document.setFilename(uploadedFilename);
        document.setContentType(FileUtil.getMimeType((String)tempFile.getPath()));
        this.checkUploadedFile(tempFile);
        document.setSize(tempFile.length());
        BufferedInputStream content = new BufferedInputStream(new FileInputStream(tempFile));
        if (!StringUtil.isDefined((String)document.getEditedBy())) {
            document.edit(this.getUser().getId());
        }
        AttachmentServiceProvider.getAttachmentService().updateAttachment(document, (InputStream)content, true, true);
        ((InputStream)content).close();
        FileUtils.deleteQuietly((File)tempFile);
        ActifyDocumentProcessor.getProcessor().process(document);
    }

    @GET
    @Path(value="translations")
    @Produces(value={"application/json"})
    public SimpleDocumentEntity[] getDocumentTranslations() {
        ArrayList<SimpleDocumentEntity> result = new ArrayList<SimpleDocumentEntity>(I18NHelper.getNumberOfLanguages());
        for (String lang : I18NHelper.getAllSupportedLanguages()) {
            SimpleDocument attachment;
            if (!lang.equals((attachment = this.getSimpleDocument(lang)).getLanguage())) continue;
            URI attachmentUri = this.getUri().getRequestUriBuilder().path(DOCUMENT_PATH_NODE).path(lang).build(new Object[0]);
            result.add(SimpleDocumentEntity.fromAttachment(attachment).withURI(attachmentUri));
        }
        return result.toArray(new SimpleDocumentEntity[0]);
    }

    public void validateUserAuthorization(UserPrivilegeValidation validation) {
        validation.validateUserAuthorizationOnAttachment(this.getHttpServletRequest(), this.getUser(), this.getSimpleDocument(null));
    }

    @GET
    @Path(value="content/{lang}")
    @Produces(value={"application/octet-stream"})
    public Response getFileContent(@PathParam(value="lang") String language) {
        SimpleDocument document = this.getSimpleDocument(language);
        SilverpeasFile file = SilverpeasFileProvider.getFile((String)document.getAttachmentPath());
        Response.ResponseBuilder responseBuilder = EmbedMediaPlayerDispatcher.from((HttpServletRequest)this.getHttpRequest().getRequest(), this.getHttpServletResponse()).seeOtherWithSilverpeasFile(file);
        if (responseBuilder == null) {
            responseBuilder = FileResponse.fromRest((HttpServletRequest)this.getHttpRequest(), this.getHttpServletResponse()).forceMimeType(document.getContentType()).silverpeasFile(file);
        }
        return responseBuilder.build();
    }

    @PUT
    @Path(value="lock/{lang}")
    @Produces(value={"application/json"})
    public String lock(@PathParam(value="lang") String language) {
        boolean result = AttachmentServiceProvider.getAttachmentService().lock(this.getSimpleDocumentId(), this.getUser().getId(), language);
        return MessageFormat.format("'{'\"status\":{0}}", result);
    }

    private List<SimpleDocument> getListDocuments(SimpleDocument document) {
        return AttachmentServiceProvider.getAttachmentService().listDocumentsByForeignKeyAndType(new ResourceReference(document.getForeignId(), this.getComponentId()), document.getDocumentType(), I18NHelper.DEFAULT_LANGUAGE);
    }

    private String reorderDocuments(List<SimpleDocument> docs) {
        AttachmentServiceProvider.getAttachmentService().reorderDocuments(docs);
        return MessageFormat.format("'{'\"status\":{0}}", true);
    }

    @PUT
    @Path(value="moveUp")
    @Produces(value={"application/json"})
    public String moveSimpleDocumentUp() {
        return this.moveSimpleDocument(true);
    }

    @PUT
    @Path(value="moveDown")
    @Produces(value={"application/json"})
    public String moveSimpleDocumentDown() {
        return this.moveSimpleDocument(false);
    }

    private String moveSimpleDocument(boolean up) {
        SimpleDocument document = this.getSimpleDocument(I18NHelper.DEFAULT_LANGUAGE);
        List<SimpleDocument> docs = this.getListDocuments(document);
        int position = docs.indexOf(document);
        Collections.swap(docs, position, up ? position - 1 : position + 1);
        return this.reorderDocuments(docs);
    }

    @POST
    @Path(value="unlock")
    @Produces(value={"application/json"})
    public String unlockDocument(@FormParam(value="force") boolean force, @FormParam(value="webdav") boolean webdav, @FormParam(value="private") boolean privateVersion, @FormParam(value="comment") String comment) {
        boolean result;
        ContributionOperationContextPropertyHandler.parseRequest((HttpServletRequest)this.getHttpRequest());
        SimpleDocument document = this.getSimpleDocument(I18NHelper.DEFAULT_LANGUAGE);
        UnlockContext unlockContext = new UnlockContext(this.getSimpleDocumentId(), this.getUser().getId(), I18NHelper.DEFAULT_LANGUAGE, comment);
        if (force) {
            unlockContext.addOption(UnlockOption.FORCE);
        }
        if (webdav) {
            unlockContext.addOption(UnlockOption.WEBDAV);
        }
        if (privateVersion) {
            unlockContext.addOption(UnlockOption.PRIVATE_VERSION);
        }
        if (result = AttachmentServiceProvider.getAttachmentService().unlock(unlockContext)) {
            WebDavTokenGenerator.getFor((User)this.getUser()).deleteToken(document.getId());
        }
        return MessageFormat.format("'{'\"status\":{0}, \"id\":{1,number,#}, \"attachmentId\":\"{2}\"}", result, document.getOldSilverpeasId(), document.getId());
    }

    @PUT
    @Path(value="switchState")
    @Produces(value={"application/json"})
    public String switchDocumentVersionState(@FormParam(value="switch-version-comment") String comment, @FormParam(value="switch-version") String version) {
        boolean useMajor = "lastMajor".equalsIgnoreCase(version);
        SimpleDocument document = this.getSimpleDocument(I18NHelper.DEFAULT_LANGUAGE);
        SimpleDocumentPK pk = new SimpleDocumentPK(this.getSimpleDocumentId());
        if (document.isVersioned() && useMajor) {
            SimpleDocument lastPublicVersion = document.getLastPublicVersion();
            if (lastPublicVersion == null) {
                throw new WebApplicationException(Response.Status.NOT_FOUND);
            }
            pk = lastPublicVersion.getPk();
        }
        pk = AttachmentServiceProvider.getAttachmentService().changeVersionState(pk, comment);
        document = AttachmentServiceProvider.getAttachmentService().searchDocumentById(pk, I18NHelper.DEFAULT_LANGUAGE);
        return MessageFormat.format("'{'\"status\":{0}, \"id\":{1,number,#}, \"attachmentId\":\"{2}\"}", true, document.getOldSilverpeasId(), document.getId());
    }

    @POST
    @Path(value="switchDownloadAllowedForReaders")
    @Produces(value={"application/json"})
    public String switchDownloadAllowedForReaders(@FormParam(value="allowed") boolean allowed) {
        SimpleDocument document = this.getSimpleDocument(null);
        AttachmentServiceProvider.getAttachmentService().switchAllowingDownloadForReaders(document.getPk(), allowed);
        return MessageFormat.format("'{'\"allowedDownloadForReaders\":{0}, \"id\":{1,number,#}, \"attachmentId\":\"{2}\"}", allowed, document.getOldSilverpeasId(), document.getId());
    }

    @POST
    @Path(value="switchDisplayAsContentEnabled")
    @Produces(value={"application/json"})
    public String switchDisplayAsContentEnabled(@FormParam(value="enabled") boolean enabled) {
        SimpleDocument document = this.getSimpleDocument(null);
        AttachmentServiceProvider.getAttachmentService().switchEnableDisplayAsContent(document.getPk(), enabled);
        return MessageFormat.format("'{'\"displayableAsContent\":{0}, \"id\":{1,number,#}, \"attachmentId\":\"{2}\"}", enabled, document.getOldSilverpeasId(), document.getId());
    }

    @POST
    @Path(value="switchEditSimultaneouslyEnabled")
    @Produces(value={"application/json"})
    public String switchEditSimultaneouslyEnabled(@FormParam(value="enabled") boolean enabled) {
        SimpleDocument document = this.getSimpleDocument(null);
        AttachmentServiceProvider.getAttachmentService().switchEnableEditSimultaneously(document.getPk(), enabled);
        return MessageFormat.format("'{'\"editableSimultaneously\":{0}, \"id\":{1,number,#}, \"attachmentId\":\"{2}\"}", enabled, document.getOldSilverpeasId(), document.getId());
    }

    private SimpleDocument getSimpleDocument(String lang) {
        String language = lang == null ? I18NHelper.DEFAULT_LANGUAGE : lang;
        SimpleDocument attachment = AttachmentServiceProvider.getAttachmentService().searchDocumentById(new SimpleDocumentPK(this.getSimpleDocumentId()), language);
        if (attachment == null) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        return attachment;
    }
}

