/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.webapi.attachment;

import java.net.URI;
import java.net.URISyntaxException;
import javax.xml.bind.annotation.XmlElement;
import org.silverpeas.core.contribution.attachment.AttachmentException;
import org.silverpeas.core.contribution.attachment.model.SimpleDocument;
import org.silverpeas.core.util.URLUtil;
import org.silverpeas.core.web.rs.WebEntity;

public class SimpleDocumentEntity
implements WebEntity {
    private static final long serialVersionUID = 6578990825699318566L;
    @XmlElement(required=true)
    private String id;
    @XmlElement(required=true)
    private Long spId;
    @XmlElement(required=true)
    private String instanceId;
    @XmlElement(required=true)
    private String fileName;
    @XmlElement(defaultValue="")
    private String description;
    @XmlElement(defaultValue="")
    private String contentType;
    @XmlElement(defaultValue="0")
    private long creationDate;
    @XmlElement(defaultValue="")
    private String createdBy;
    @XmlElement(defaultValue="0")
    private long updateDate;
    @XmlElement(defaultValue="")
    private String updatedBy;
    @XmlElement(defaultValue="0")
    private long size;
    @XmlElement(defaultValue="")
    private String title;
    @XmlElement(defaultValue="")
    private String lang;
    @XmlElement(required=true)
    private URI uri;
    @XmlElement(required=true)
    private String icon;
    @XmlElement(required=true)
    private String permalink;
    @XmlElement(defaultValue="")
    private String downloadUrl;
    @XmlElement(defaultValue="")
    private String comment;
    @XmlElement(defaultValue="false")
    private String versioned;
    @XmlElement
    private Boolean prewiewable;
    @XmlElement
    private Boolean viewable;
    @XmlElement
    private Boolean displayAsContent;
    @XmlElement
    private Integer widthInPixel;
    @XmlElement
    private Integer heightInPixel;

    public static SimpleDocumentEntity fromAttachment(SimpleDocument document) {
        SimpleDocumentEntity entity = new SimpleDocumentEntity();
        try {
            entity.uri = new URI(URLUtil.getSimpleURL((int)4, (String)document.getId()));
        }
        catch (URISyntaxException e) {
            throw new AttachmentException("Couldn't build the URI to the attachment", (Throwable)e);
        }
        entity.id = document.getId();
        entity.spId = document.getOldSilverpeasId();
        entity.instanceId = document.getInstanceId();
        entity.fileName = document.getFilename();
        entity.description = document.getDescription();
        entity.size = document.getSize();
        entity.creationDate = document.getCreationDate().getTime();
        entity.createdBy = document.getCreatedBy();
        if (document.getLastUpdateDate() != null) {
            entity.updateDate = document.getLastUpdateDate().getTime();
        }
        entity.updatedBy = document.getUpdatedBy();
        entity.title = document.getTitle();
        entity.contentType = document.getContentType();
        entity.icon = document.getDisplayIcon();
        entity.permalink = URLUtil.getSimpleURL((int)4, (String)document.getId());
        entity.downloadUrl = document.getAttachmentURL();
        entity.lang = document.getLanguage();
        entity.comment = document.getComment();
        entity.versioned = String.valueOf(document.isVersioned());
        return entity;
    }

    public SimpleDocumentEntity withURI(URI uri) {
        this.uri = uri;
        return this;
    }

    public URI getURI() {
        return this.uri;
    }

    public String getId() {
        return this.id;
    }

    public Long getSpId() {
        return this.spId;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getDescription() {
        return this.description;
    }

    public String getContentType() {
        return this.contentType;
    }

    public long getCreationDate() {
        return this.creationDate;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public long getUpdateDate() {
        return this.updateDate;
    }

    public String getUpdatedBy() {
        return this.updatedBy;
    }

    public long getSize() {
        return this.size;
    }

    public String getTitle() {
        return this.title;
    }

    public String getLang() {
        return this.lang;
    }

    public String getIcon() {
        return this.icon;
    }

    public String getPermalink() {
        return this.permalink;
    }

    public String getDownloadUrl() {
        return this.downloadUrl;
    }

    public String getComment() {
        return this.comment;
    }

    public String getVersioned() {
        return this.versioned;
    }

    public Boolean getPrewiewable() {
        return this.prewiewable;
    }

    public SimpleDocumentEntity prewiewable(boolean prewiewable) {
        this.prewiewable = prewiewable;
        return this;
    }

    public Boolean getViewable() {
        return this.viewable;
    }

    public SimpleDocumentEntity viewable(boolean viewable) {
        this.viewable = viewable;
        return this;
    }

    public Boolean getDisplayAsContent() {
        return this.displayAsContent;
    }

    public SimpleDocumentEntity displayAsContent(boolean displayAsContent) {
        this.displayAsContent = displayAsContent;
        return this;
    }

    public Integer getWidthInPixel() {
        return this.widthInPixel;
    }

    public SimpleDocumentEntity widthInPixelOf(Integer width) {
        this.widthInPixel = width;
        return this;
    }

    public Integer getHeightInPixel() {
        return this.heightInPixel;
    }

    public SimpleDocumentEntity heightInPixelOf(Integer height) {
        this.heightInPixel = height;
        return this;
    }
}

