/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.webapi.attachment;

import java.io.File;
import java.text.MessageFormat;
import javax.ws.rs.PathParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.commons.io.FileUtils;
import org.silverpeas.core.notification.message.MessageNotifier;
import org.silverpeas.core.util.UnitUtil;
import org.silverpeas.core.util.error.SilverpeasTransverseErrorUtil;
import org.silverpeas.core.util.file.FileRepositoryManager;
import org.silverpeas.core.web.rs.RESTWebService;
import org.silverpeas.kernel.util.StringUtil;

public abstract class AbstractSimpleDocumentResource
extends RESTWebService {
    static final String PATH = "documents";
    @PathParam(value="componentId")
    private String componentId;

    protected String getResourceBasePath() {
        return PATH;
    }

    public String getComponentId() {
        return this.componentId;
    }

    protected String getBundleLocation() {
        return "org.silverpeas.util.attachment.multilang.attachment";
    }

    protected void checkUploadedFile(File fileToCheck) {
        try {
            long maximumFileSize = FileRepositoryManager.getUploadMaximumFileSize();
            long fileSize = fileToCheck.length();
            if (fileSize > maximumFileSize) {
                Object errorMessage = this.getBundle().getString("attachment.dialog.errorFileSize") + " " + this.getBundle().getString("attachment.dialog.maximumFileSize") + " (" + UnitUtil.formatMemSize((long)maximumFileSize) + ")";
                errorMessage = MessageFormat.format((String)errorMessage, fileToCheck.getName());
                MessageNotifier.addError((String)errorMessage, (Object[])new Object[0]);
                throw new WebApplicationException(Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).entity(errorMessage).build());
            }
        }
        catch (RuntimeException re) {
            FileUtils.deleteQuietly((File)fileToCheck);
            throw re;
        }
    }

    protected void performRuntimeException(RuntimeException re) {
        String transverseExceptionMessage = SilverpeasTransverseErrorUtil.performExceptionMessage((Exception)re, (String)this.getUserPreferences().getLanguage());
        if (StringUtil.isDefined((String)transverseExceptionMessage)) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).entity((Object)transverseExceptionMessage).build());
        }
        throw re;
    }
}

